/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.context.ContextStack;
import net.edgemind.ibee.core.context.IContext;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;

public class LogUtil {
    public static String sDefaultConsole = "DEFAULT";
    public static LogLevel sDefaultLogLevel = LogLevel.INFO;
    private static List<ILogHandler> sDefaultLogHandler = new ArrayList<ILogHandler>();

    public static void addHandler(ILogHandler handler) {
        sDefaultLogHandler.add(handler);
    }

    public static void addHandler(final OutputStream handler, final String handlerName, LogLevel level) {
        LogUtil.addHandler(new ALogHandler(){

            @Override
            public String getName() {
                return handlerName;
            }

            @Override
            public void log(String msg, LogLevel level) {
                try {
                    handler.write(msg.getBytes());
                    handler.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void log(Throwable e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.log(writer.getBuffer().toString(), LogLevel.ERROR);
            }

            @Override
            public LogLevel getLogLevel() {
                return null;
            }
        });
    }

    public static void removeHandler(ILogHandler handler) {
        sDefaultLogHandler.remove(handler);
    }

    public static synchronized void removeHandler(String handlerName) {
        ArrayList<ILogHandler> copy = new ArrayList<ILogHandler>(sDefaultLogHandler);
        for (ILogHandler handler : copy) {
            if (!handlerName.equalsIgnoreCase(handler.getName())) continue;
            sDefaultLogHandler.remove(handler);
        }
    }

    public static void info(String msg) {
        LogUtil.log(msg, LogLevel.INFO);
    }

    public static void log(String msg) {
        LogUtil.log(msg, LogLevel.INFO);
    }

    public static void error(String msg) {
        LogUtil.log(msg, LogLevel.ERROR);
    }

    public static void error(Throwable e) {
        LogUtil.log(e, LogLevel.ERROR);
    }

    public static void log(Throwable e) {
        LogUtil.log(e, LogLevel.ERROR);
    }

    public static void warning(String msg) {
        LogUtil.log(msg, LogLevel.WARNING);
    }

    public static void debug(String msg) {
        LogUtil.log(msg, LogLevel.DEBUG);
    }

    public static void debug(Throwable e) {
        LogUtil.log(e.getMessage(), LogLevel.DEBUG);
    }

    public static void log(String msg, LogLevel level) {
        ILogHandler taskLogHandler = LogUtil.getCurrentTaskLogHandler();
        if (taskLogHandler != null) {
            if (LogUtil.doLog(level, taskLogHandler)) {
                taskLogHandler.log(msg, level);
            }
        } else {
            for (ILogHandler handler : sDefaultLogHandler) {
                if (!LogUtil.doLog(level, handler)) continue;
                handler.log(msg, level);
            }
        }
    }

    public static void log(Throwable e, LogLevel level) {
        ILogHandler taskLogHandler = LogUtil.getCurrentTaskLogHandler();
        if (taskLogHandler != null) {
            if (LogUtil.doLog(level, taskLogHandler)) {
                taskLogHandler.log(e);
            }
        } else {
            for (ILogHandler handler : sDefaultLogHandler) {
                if (!LogUtil.doLog(level, handler)) continue;
                handler.log(e);
            }
        }
    }

    private static boolean doLog(LogLevel logLevel, ILogHandler handler) {
        if (handler.getLogLevel() != null) {
            return handler.getLogLevel().ordinal() >= logLevel.ordinal();
        }
        return sDefaultLogLevel.ordinal() >= logLevel.ordinal();
    }

    public static ILogHandler getCurrentTaskLogHandler() {
        IContext taskContext = ContextStack.getCurrentContext();
        if (taskContext != null) {
            ILogHandler logHandler = taskContext.getValue(ILogHandler.class);
            return logHandler;
        }
        return null;
    }

    public static boolean setCurrentLogHandler(ILogHandler logHandler) {
        IContext taskContext = ContextStack.getCurrentContext();
        if (taskContext != null) {
            taskContext.setValue(ILogHandler.class, logHandler);
            return true;
        }
        return false;
    }

    public static void redirectOutputStream() {
        System.setOut(LogUtil.createSystemStream(LogLevel.INFO));
    }

    public static void redirectErrorStream() {
        System.setErr(LogUtil.createSystemStream(LogLevel.ERROR));
    }

    private static PrintStream createSystemStream(final LogLevel logLevel) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(){

            @Override
            public void flush() throws IOException {
                String msg = super.toString();
                if (msg.endsWith("\n")) {
                    msg = msg.substring(0, msg.length() - 1);
                }
                LogUtil.log(msg, logLevel);
                super.reset();
            }
        };
        PrintStream newStream = new PrintStream(outStream, true);
        return newStream;
    }
}

