/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.util.file.FileUtil;

public class LogWrapper
extends ALogHandler
implements ILogHandler,
Closeable,
Flushable {
    protected ILogHandler wrapped;
    protected boolean record = true;
    protected StringBuffer buf = new StringBuffer();
    private boolean hasWarnings;
    private boolean hasErrors;

    public StringBuffer getStringBuffer() {
        return this.buf;
    }

    public ILogHandler getWrappedUserIO() {
        return this.wrapped;
    }

    public void setWrappedHandler(ILogHandler logHandler) {
        this.wrapped = logHandler;
    }

    public void setRecord(boolean value) {
        this.record = value;
    }

    @Override
    public void log(String msg, LogLevel level) {
        this.updateWarningErrorStatus(level);
        if (this.record) {
            this.buf.append(msg + FileUtil.lineSeparator());
        }
        this.wrapped.log(msg, level);
    }

    @Override
    public void log(Throwable e, LogLevel level) {
        this.updateWarningErrorStatus(level);
        if (this.record) {
            this.buf.append(e.getMessage() + FileUtil.lineSeparator());
        }
        this.wrapped.log(e, level);
    }

    private void updateWarningErrorStatus(LogLevel level) {
        if (level == LogLevel.ERROR) {
            this.hasErrors = true;
        } else if (level == LogLevel.WARNING) {
            this.hasWarnings = true;
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    @Override
    public void close() throws IOException {
        if (this.wrapped instanceof Closeable) {
            ((Closeable)((Object)this.wrapped)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.wrapped instanceof Flushable) {
            ((Flushable)((Object)this.wrapped)).flush();
        }
    }
}

