/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.log;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.function.Function;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.util.Tuple;

public class StreamLogHandler
extends ALogHandler {
    private OutputStream outStream = System.out;
    private OutputStream errStream = System.err;
    private Function<Tuple<String, LogLevel>, String> messageCreator = logEntry -> String.format("[%s,%s] %s", ((LogLevel)((Object)((Object)logEntry.second))).toString(), new Date().toString(), logEntry.first);

    public StreamLogHandler() {
        super.setName("StreamLogHandler");
    }

    public void setStreams(OutputStream out) {
        this.outStream = out;
        this.errStream = out;
    }

    public void setStreams(OutputStream out, OutputStream err) {
        this.outStream = out;
        this.errStream = err;
    }

    public Function<Tuple<String, LogLevel>, String> getMessageCreator() {
        return this.messageCreator;
    }

    public StreamLogHandler setMessageCreator(Function<Tuple<String, LogLevel>, String> messageCreator) {
        this.messageCreator = messageCreator;
        return this;
    }

    @Override
    public void log(String msg, LogLevel level) {
        String msg2 = this.messageCreator.apply((Tuple<String, LogLevel>)new Tuple((Object)msg, (Object)level));
        try {
            if (level == LogLevel.ERROR) {
                this.errStream.write(msg2.getBytes());
            } else {
                this.outStream.write(msg2.getBytes());
            }
        }
        catch (IOException e) {
            LogUtil.log(e);
        }
    }
}

