/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.monitor;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.able.IResetAble;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.monitor.IMultiTaskMonitor;
import org.eclipse.core.runtime.IProgressMonitor;

public class MultiTaskProgressMonitor
implements IProgressMonitor,
IMultiTaskMonitor,
IResetAble {
    private List<Integer> weights = new ArrayList<Integer>();
    private IProgressMonitor wrapped;
    private int currentTaskNr = -1;
    private int currentWorked;
    private int currentTotal;
    private int lastCommunicatedProgress;
    private int currentTaskDepth = 0;
    private String currentTaskName;

    public MultiTaskProgressMonitor(IProgressMonitor wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void init(int[] taskWeights) {
        int[] nArray = taskWeights;
        int n = taskWeights.length;
        int n2 = 0;
        while (n2 < n) {
            int weight = nArray[n2];
            this.declareTask(weight);
            ++n2;
        }
    }

    public void declareTask(int weight) {
        this.weights.add(weight);
    }

    public int getTaskCount() {
        return this.weights.size();
    }

    int getStartingWeight() {
        int sum = 0;
        int i = 0;
        while (i < this.currentTaskNr) {
            sum += this.weights.get(i).intValue();
            ++i;
        }
        return sum;
    }

    int getWeight(int taskNr) {
        int weight = 0;
        if (taskNr < this.weights.size()) {
            weight = this.weights.get(taskNr);
        } else {
            LogUtil.error(String.format("no weight defined for task %d (%s)", taskNr, this.currentTaskName));
        }
        return weight;
    }

    int getTotalWeight() {
        int sum = 0;
        for (int w : this.weights) {
            sum += w;
        }
        return sum;
    }

    public void beginTask(String name, int totalWork) {
        ++this.currentTaskDepth;
        if (this.currentTaskDepth == 1 && this.getTaskCount() > 0) {
            ++this.currentTaskNr;
            this.currentTotal = totalWork;
            this.lastCommunicatedProgress = 0;
            this.currentWorked = 0;
            this.currentTaskName = name;
            String post = "";
            if (this.getTaskCount() > 1) {
                post = String.format(" (%d/%d)", this.currentTaskNr + 1, this.getTaskCount());
            }
            this.wrapped.beginTask(String.format("%s%s", name, post), this.getTotalWeight());
            this.lastCommunicatedProgress = this.getStartingWeight();
            this.wrapped.worked(this.lastCommunicatedProgress);
        } else {
            this.wrapped.beginTask(name, totalWork);
        }
    }

    public void done() {
        this.wrapped.done();
        --this.currentTaskDepth;
    }

    public void internalWorked(double work) {
        this.wrapped.internalWorked(work);
    }

    public boolean isCanceled() {
        return this.wrapped.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.wrapped.setCanceled(value);
    }

    public void setTaskName(String name) {
        this.wrapped.setTaskName(name);
    }

    public void subTask(String name) {
        this.wrapped.subTask(name);
    }

    public void worked(int work) {
        if (this.currentTaskDepth == 1 && this.getTaskCount() > 0) {
            this.currentWorked += work;
            double totalWorked = (int)((double)this.getStartingWeight() + (double)this.currentWorked / (double)this.currentTotal * (double)this.getWeight(this.currentTaskNr));
            int totalWorkedInt = (int)totalWorked;
            if (totalWorkedInt != this.lastCommunicatedProgress) {
                this.wrapped.worked(totalWorkedInt - this.lastCommunicatedProgress);
                this.lastCommunicatedProgress = totalWorkedInt;
            }
        } else {
            this.wrapped.worked(work);
        }
    }

    @Override
    public void reset() {
        this.weights.clear();
        this.currentTaskNr = -1;
        this.currentWorked = 0;
        this.currentTotal = 0;
        this.lastCommunicatedProgress = 0;
        this.currentTaskDepth = 0;
        this.currentTaskName = null;
        if (this.wrapped instanceof IResetAble) {
            ((IResetAble)this.wrapped).reset();
        }
    }
}

