/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.able.IResetAble;
import org.eclipse.core.runtime.IProgressMonitor;

public class TopLevelMonitor
implements IProgressMonitor,
IResetAble {
    private int currentLevel = 0;
    private Map<Integer, LevelProgress> progresses = new HashMap<Integer, LevelProgress>();
    private boolean isCancelled = false;
    private List<Integer> topLevels = new ArrayList<Integer>();
    private Listener listener;

    public void setProgressListener(Listener listener) {
        this.listener = listener;
    }

    public TopLevelMonitor(List<Integer> topLevels) {
        this.topLevels.addAll(topLevels);
    }

    public TopLevelMonitor(int ... topLevels) {
        int[] nArray = topLevels;
        int n = topLevels.length;
        int n2 = 0;
        while (n2 < n) {
            int level = nArray[n2];
            this.topLevels.add(level);
            ++n2;
        }
    }

    private LevelProgress getLevelProgress(int level, boolean create) {
        LevelProgress lp = this.progresses.get(level);
        if (lp == null && create) {
            lp = new LevelProgress();
            lp.subTaskName = "";
            lp.taskName = "";
            this.progresses.put(level, lp);
        }
        return lp;
    }

    public void beginTask(String name, int totalWork) {
        ++this.currentLevel;
        if (this.topLevels.contains(this.currentLevel)) {
            LevelProgress lp = this.getLevelProgress(this.currentLevel, true);
            lp.totalWork = totalWork;
            lp.progress10000 = 0;
            lp.currentWork = 0;
            lp.taskName = name;
            lp.subTaskName = "";
            if (this.listener != null) {
                this.listener.setTaskName(name, this.currentLevel);
            }
        }
    }

    private void restoreLevel(int level) {
        LevelProgress lp = this.getLevelProgress(level, false);
        if (lp != null) {
            this.listener.setTaskName(lp.taskName, level);
            this.listener.setSubTaskName(lp.subTaskName, level);
            this.listener.setProgress((double)lp.progress10000 / 10000.0, level);
        }
    }

    public void done() {
        --this.currentLevel;
        if (this.topLevels.contains(this.currentLevel) && this.topLevels.size() > 1) {
            this.restoreLevel(this.currentLevel);
        }
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.isCancelled;
    }

    public void setCanceled(boolean value) {
        this.isCancelled = value;
    }

    public void setTaskName(String name) {
        if (this.topLevels.contains(this.currentLevel)) {
            LevelProgress lp = this.getLevelProgress(this.currentLevel, true);
            lp.taskName = name;
            lp.subTaskName = "";
            if (this.listener != null) {
                this.listener.setTaskName(lp.taskName, this.currentLevel);
            }
        }
    }

    public void subTask(String name) {
        if (this.topLevels.contains(this.currentLevel)) {
            LevelProgress lp = this.getLevelProgress(this.currentLevel, true);
            lp.subTaskName = name;
            if (this.listener != null) {
                this.listener.setSubTaskName(name, this.currentLevel);
            }
        }
    }

    public void worked(int work) {
        if (work == 0) {
            return;
        }
        if (this.topLevels.contains(this.currentLevel)) {
            LevelProgress lp = this.getLevelProgress(this.currentLevel, true);
            lp.currentWork += work;
            double exactProgress10000 = (double)lp.currentWork / (double)lp.totalWork * 10000.0;
            int intProgress10000 = (int)exactProgress10000;
            if (intProgress10000 != lp.progress10000) {
                lp.progress10000 = intProgress10000;
                if (this.listener != null) {
                    double progress = (double)lp.progress10000 / 10000.0;
                    if (progress > 1.0) {
                        progress = 1.0;
                    }
                    if (progress < 0.0) {
                        progress = 0.0;
                    }
                    this.listener.setProgress(progress, this.currentLevel);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.currentLevel = 0;
        this.progresses.clear();
        this.isCancelled = false;
    }

    public class LevelProgress {
        private int currentWork;
        private int totalWork;
        private int progress10000;
        private String taskName;
        private String subTaskName;
    }

    public static interface Listener {
        public void setSubTaskName(String var1, int var2);

        public void setTaskName(String var1, int var2);

        public void setProgress(double var1, int var3);
    }
}

