/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.core.iml.domain.impl.DisplayNameCreator;
import net.edgemind.ibee.core.property.IProperty;

public abstract class AProperty<T, U>
implements IProperty<T, U> {
    public static String DEFAULT_DELIMITER = ",";
    private String name;
    private String displayName;
    private boolean editable = true;
    private String unit;
    private String description;
    private T defaultValue;
    private Map<Class<?>, Object> support = new HashMap();

    public AProperty(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = DisplayNameCreator.getDisplayName(this.name);
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public AProperty<T, U> setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public AProperty<T, U> setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public AProperty<T, U> setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public AProperty<T, U> setEditAble(boolean value) {
        this.editable = value;
        return this;
    }

    @Override
    public boolean editAble() {
        return this.editable;
    }

    @Override
    public T getInheritedValue(U element) {
        return this.getDefaultValue();
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public <C> C getSupport(Class<C> clazz) {
        return (C)this.support.get(clazz);
    }

    @Override
    public <C> void setSupport(C support, Class<C> clazz) {
        this.support.put(clazz, support);
    }
}

