/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import javax.swing.CellEditor;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.IProvidesChoices;
import net.edgemind.ibee.core.property.StringPropertyIMF;

public class GenericAttrPropertyIMF
extends StringPropertyIMF
implements IProvidesChoices {
    private String attr;
    private Object[] enums;
    private String[] enumsLabels;
    private boolean isRequired = false;
    private CellEditor attrEditor;

    public GenericAttrPropertyIMF(String name, String attr) {
        super(name);
        this.attr = attr;
    }

    public GenericAttrPropertyIMF(String name, String attr, String[] enums) {
        super(name);
        this.attr = attr;
        this.enums = enums;
        this.enumsLabels = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            this.enumsLabels[i] = enums[i].toUpperCase();
            ++i;
        }
    }

    public GenericAttrPropertyIMF(String name, String attr, Object[] enums) {
        super(name);
        this.attr = attr;
        this.enums = new String[enums.length];
        this.enumsLabels = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            this.enums[i] = enums[i].toString().toLowerCase();
            this.enumsLabels[i] = enums[i].toString().toUpperCase();
            ++i;
        }
    }

    public GenericAttrPropertyIMF(String name, String attr, Object[] enums, String[] enumsLabels) {
        super(name);
        this.attr = attr;
        this.enums = new String[enums.length];
        int i = 0;
        while (i < enums.length) {
            this.enums[i] = enums[i].toString();
            this.enumsLabels[i] = enumsLabels[i].toString();
            ++i;
        }
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public String getAttr(IElementType<?> type) {
        return this.attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public Object getEditValue(IElement element) {
        String value = element.giGetAttribute(this.getAttr(element.giGetElementType())).trim();
        if (this.enums != null) {
            int index = 0;
            while (index < this.enums.length) {
                Object next = this.enums[index];
                if (next.equals(value)) {
                    return index;
                }
                ++index;
            }
            return 0;
        }
        return value;
    }

    @Override
    public String getValue(IElement element) {
        String attr = this.getAttr(element.giGetElementType());
        String value = element.giGetAttribute(attr).trim();
        if (this.enums != null) {
            int index = 0;
            while (index < this.enums.length) {
                String next = this.enums[index].toString();
                if (next.equalsIgnoreCase(value)) {
                    value = this.enumsLabels[index];
                    break;
                }
                ++index;
            }
        }
        return value;
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        String newValue = null;
        if (this.enums != null && value instanceof Integer) {
            int index = (Integer)value;
            newValue = index >= 0 && index < this.enums.length ? (String)this.enums[index] : "";
        }
        if (value instanceof String) {
            String currentValue = this.getValue(element);
            if (currentValue.equals(value)) {
                return false;
            }
            newValue = (String)value;
        }
        if (newValue != null) {
            element.giSetAttribute(this.getAttr(element.giGetElementType()), newValue);
        }
        return newValue != null;
    }

    @Override
    public boolean editAble() {
        return true;
    }

    @Override
    public String checkEditValue(IElement element, Object val) {
        String error = null;
        if (val instanceof String) {
            String strValue = (String)val;
            IAttributeFeature attr = element.giGetElementType().getAttributeFeature(this.attr);
            if (attr != null) {
                IType<?> type = attr.getType();
                if (strValue == null || strValue.length() == 0) {
                    if (attr.isRequired()) {
                        return "value must not be empty";
                    }
                    return null;
                }
                if (!type.isTypeValue(strValue)) {
                    return "Invalid Value";
                }
            }
        }
        return error;
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    @Override
    public Object[] getChoices() {
        return this.enums;
    }

    @Override
    public String[] getChoiceLabels() {
        return this.enumsLabels;
    }
}

