/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.property.ElementPropertyIMF;
import net.edgemind.ibee.util.string.StringUtil;

public class ListPropertyIMF<T extends IElement>
extends ElementPropertyIMF<List<String>> {
    private IListFeature<T> childType;
    private String delimiter = ",";
    private IAttributeFeature childAttr;

    public void setChildType(IListFeature<T> childType) {
        this.childType = childType;
    }

    public ListPropertyIMF(String name, IListFeature<T> child, IAttributeFeature childAttr) {
        super(name);
        this.childAttr = childAttr;
        this.childType = child;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ListPropertyIMF<T> setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public IAttributeFeature getChildAttr() {
        return this.childAttr;
    }

    public void setChildAttr(IAttributeFeature childAttr) {
        this.childAttr = childAttr;
    }

    public IListFeature<? extends IElement> getChildType() {
        return this.childType;
    }

    @Override
    public Object getEditValue(IElement element) {
        return this.getValue(element);
    }

    @Override
    public String checkEditValue(IElement element, Object editValue) {
        if (this.isEmpty(editValue)) {
            if (this.isRequired()) {
                return this.checkEmpty(editValue);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        element.giGetList(this.childType).clear();
        IElementType<T> type = this.childType.getTypes().get(0);
        if (value instanceof String) {
            String[] stringArray = value.toString().split(this.delimiter);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String refString = stringArray[n2];
                T newEl = type.getDomain().create(type);
                element.giGetList(this.childType).add(newEl);
                newEl.giSetAttribute(this.childAttr, refString);
                ++n2;
            }
        }
        return true;
    }

    @Override
    public List<String> getValue(IElement element) {
        ArrayList<String> list = new ArrayList<String>();
        if (element == null) {
            return list;
        }
        for (IElement child : element.giGetList(this.childType).getElements()) {
            list.add(child.giGetAttribute(this.childAttr));
        }
        return list;
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    @Override
    public int compareTo(List<String> v1, List<String> v2) {
        return this.toString(v1).compareTo(this.toString(v2));
    }

    @Override
    public String toString(List<String> list) {
        StringBuffer buf = new StringBuffer();
        if (list == null) {
            return "";
        }
        StringUtil.performStringSort(list);
        for (String s : list) {
            if (buf.length() > 0) {
                buf.append(this.delimiter);
            }
            buf.append(s);
        }
        return buf.toString();
    }
}

