/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.ImfReferenceType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.iml.model.ImfNamedReference;
import net.edgemind.ibee.core.property.ElementPropertyIMF;
import net.edgemind.ibee.core.resource.GlobalKey;

public class ReferenceListPropertyIMF<T extends ImfNamedReference>
extends ElementPropertyIMF<List<T>> {
    private IListFeature<T> childType;
    private String delimiter = DEFAULT_DELIMITER;
    private IAttributeFeature childAttr;
    private List<IAttributeFeature> otherDisplayedChildAttribute;

    public void setChildType(IListFeature<T> childType) {
        this.childType = childType;
    }

    public ReferenceListPropertyIMF(String name, IListFeature<T> child, IAttributeFeature childAttr) {
        this(name, child, childAttr, new ArrayList<IAttributeFeature>());
    }

    public ReferenceListPropertyIMF(String name, IListFeature<T> child, IAttributeFeature childAttr, List<IAttributeFeature> otherDisplayedChildAttribute) {
        super(name);
        this.childAttr = childAttr;
        this.childType = child;
        this.otherDisplayedChildAttribute = otherDisplayedChildAttribute;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ReferenceListPropertyIMF setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public IAttributeFeature getChildAttr() {
        return this.childAttr;
    }

    public void setChildAttr(IAttributeFeature childAttr) {
        this.childAttr = childAttr;
    }

    public IListFeature<T> getChildType() {
        return this.childType;
    }

    public List<IAttributeFeature> getOtherDisplayedChildAttribute() {
        return this.otherDisplayedChildAttribute;
    }

    public void setOtherDisplayedChildAttribute(List<IAttributeFeature> otherDisplayedChildAttribute) {
        this.otherDisplayedChildAttribute = otherDisplayedChildAttribute;
    }

    @Override
    public Object getEditValue(IElement element) {
        return this.getValue(element);
    }

    @Override
    public String checkEditValue(IElement element, Object editValue) {
        if (this.isEmpty(editValue)) {
            if (this.isRequired()) {
                return this.checkEmpty(editValue);
            }
            return null;
        }
        if (editValue instanceof String) {
            String sValue = (String)editValue;
            String[] stringArray = sValue.split(this.delimiter);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String refString = stringArray[n2];
                if (!(refString = refString.trim()).isEmpty()) {
                    boolean validRef;
                    ImfReferenceType type = (ImfReferenceType)this.childType.getTypes().get(0);
                    IElementType<?> targetType = type.getTargetTypes().get(0);
                    GlobalKey key = new GlobalKey(targetType);
                    key.put(type.getAttributeFeature("name"), refString);
                    boolean bl = validRef = element.giGetResource().getGlobalElements(key, false, true).size() > 0;
                    if (!validRef) {
                        return "Invalid Reference";
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        block5: {
            IElementType<T> type;
            block4: {
                element.giGetList(this.childType).clear();
                type = this.childType.getTypes().get(0);
                if (!(value instanceof List)) break block4;
                List targets = (List)value;
                if (!this.childType.isOrdered()) {
                    this.sortAlphabetically(targets);
                }
                for (IElement target : targets) {
                    ImfNamedReference ref = (ImfNamedReference)type.getDomain().create(type);
                    element.giGetList(this.childType).add(ref);
                    ref.setTarget(target);
                }
                break block5;
            }
            if (!(value instanceof String)) break block5;
            String[] stringArray = value.toString().split(this.delimiter);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String refString = stringArray[n2];
                if (!(refString = refString.trim()).isEmpty()) {
                    ImfNamedReference ref = (ImfNamedReference)type.getDomain().create(type);
                    element.giGetList(this.childType).add(ref);
                    ref.giSetAttribute(this.childAttr, refString);
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public List<T> getValue(IElement element) {
        ArrayList<ImfNamedReference> list = new ArrayList<ImfNamedReference>();
        if (element == null) {
            return list;
        }
        for (ImfNamedReference ref : element.giGetList(this.childType).getElements()) {
            list.add(ref);
        }
        return list;
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    @Override
    public int compareTo(List<T> v1, List<T> v2) {
        return 0;
    }

    @Override
    public String toString(List<T> list) {
        StringBuffer buf = new StringBuffer();
        if (list == null) {
            return "";
        }
        if (!this.childType.isOrdered()) {
            this.sortAlphabetically(list);
        }
        for (IElement e : list) {
            if (buf.length() > 0) {
                buf.append(this.delimiter);
            }
            if (e instanceof ImfNamedElement) {
                buf.append(((ImfNamedElement)e).getName());
                continue;
            }
            buf.append(e.giGetAttribute("name"));
        }
        return buf.toString();
    }

    private void sortAlphabetically(List<? extends IElement> list) {
        list.sort((Comparator<? extends IElement>)new Comparator<IElement>(){

            @Override
            public int compare(IElement o1, IElement o2) {
                String so1 = o1 instanceof ImfNamedElement ? ((ImfNamedElement)o1).getName() : o1.toString();
                String so2 = o2 instanceof ImfNamedElement ? ((ImfNamedElement)o2).getName() : o2.toString();
                return so1.compareToIgnoreCase(so2);
            }
        });
    }

    @Override
    public boolean isRequired() {
        if (this.childType != null) {
            if (this.childType.isRequired()) {
                return this.childAttr.isRequired();
            }
            return this.childType.isRequired();
        }
        return super.isRequired();
    }
}

