/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.property;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.ImfReferenceType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.ImfNamedReference;
import net.edgemind.ibee.core.property.ElementPropertyIMF;
import net.edgemind.ibee.core.resource.GlobalKey;

public class ReferencePropertyIMF<T extends ImfNamedReference>
extends ElementPropertyIMF<T> {
    private IElementFeature<T> childType;
    private String delimiter = ",";
    private List<IAttributeFeature> otherDisplayedChildAttribute;
    private IAttributeFeature childAttr;

    public void setChildType(IElementFeature<T> childType) {
        this.childType = childType;
    }

    public ReferencePropertyIMF(String name, IElementFeature<T> child, IAttributeFeature childAttr) {
        this(name, child, childAttr, new ArrayList<IAttributeFeature>());
    }

    public ReferencePropertyIMF(String name, IElementFeature<T> child, IAttributeFeature childAttr, List<IAttributeFeature> otherDisplayedChildAttribute) {
        super(name);
        this.childAttr = childAttr;
        this.childType = child;
        this.otherDisplayedChildAttribute = otherDisplayedChildAttribute;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public ReferencePropertyIMF<T> setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public IAttributeFeature getChildAttr() {
        return this.childAttr;
    }

    public void setChildAttr(IAttributeFeature childAttr) {
        this.childAttr = childAttr;
    }

    public List<IAttributeFeature> getOtherDisplayedChildAttribute() {
        return this.otherDisplayedChildAttribute;
    }

    public void setOtherDisplayedChildAttribute(List<IAttributeFeature> otherDisplayedChildAttribute) {
        this.otherDisplayedChildAttribute = otherDisplayedChildAttribute;
    }

    public IElementFeature<? extends ImfNamedReference> getChildType() {
        return this.childType;
    }

    @Override
    public Object getEditValue(IElement element) {
        return this.getValue(element);
    }

    @Override
    public String checkEditValue(IElement element, Object editValue) {
        if (this.isEmpty(editValue)) {
            if (this.isRequired()) {
                return this.checkEmpty(editValue);
            }
            return null;
        }
        if (editValue instanceof IElement) {
            IElementType<? extends IElement> type;
            ImfReferenceType refType = (ImfReferenceType)this.childType.getTypes().get(0);
            List<IElementType<?>> validTargetTypes = refType.getTargetTypes();
            if (!validTargetTypes.contains(type = ((IElement)editValue).giGetElementType())) {
                return "Invalid Type";
            }
        } else if (editValue instanceof String) {
            boolean validRef;
            ImfReferenceType refType = (ImfReferenceType)this.childType.getTypes().get(0);
            IElementType<?> targetType = refType.getTargetTypes().get(0);
            GlobalKey key = new GlobalKey(targetType);
            key.put(targetType.getAttributeFeature("name"), (String)editValue);
            boolean bl = validRef = element.giGetResource().getGlobalElements(key, false, true).size() > 0;
            if (!validRef) {
                return "Invalid Reference";
            }
        }
        return null;
    }

    @Override
    public boolean setEditValue(IElement element, Object value) {
        IElementType<T> type = this.childType.getTypes().get(0);
        if (value instanceof IElement) {
            IElement target = (IElement)value;
            ImfNamedReference ref = (ImfNamedReference)type.getDomain().create(type);
            element.giGetElement(this.childType).setElement(ref);
            ref.setTarget(target);
        } else if (value instanceof String) {
            ImfNamedReference ref = (ImfNamedReference)type.getDomain().create(type);
            element.giGetElement(this.childType).setElement(ref);
            ref.giSetAttribute(this.childAttr, (String)value);
        }
        return true;
    }

    @Override
    public T getValue(IElement element) {
        if (element == null) {
            return null;
        }
        return (T)((ImfNamedReference)element.giGetElement(this.childType).getElement());
    }

    @Override
    public String checkValue(IElement element) {
        return null;
    }

    @Override
    public String toString(T element) {
        StringBuffer buf = new StringBuffer();
        if (element == null) {
            return "";
        }
        if (buf.length() > 0) {
            buf.append(this.delimiter);
        }
        buf.append(element.getName());
        return buf.toString();
    }

    @Override
    public int compareTo(T obj1, T obj2) {
        return obj1.getName().compareToIgnoreCase(obj2.getName());
    }

    @Override
    public boolean isRequired() {
        if (this.childType != null) {
            return this.childType.isRequired();
        }
        return super.isRequired();
    }
}

