/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource;

import net.edgemind.ibee.core.context.Context;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.Variant;
import net.edgemind.ibee.core.iml.modules.vm.IAttributeAssignment;
import net.edgemind.ibee.core.iml.modules.vm.IVariant;
import net.edgemind.ibee.core.iml.modules.vm.IVariantManagement;
import net.edgemind.ibee.core.resource.AttributeAssignment;
import net.edgemind.ibee.core.resource.IbeeResource;

public class ContextUtil {
    public static IVariant getModelContext(String contextName, IbeeResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getRoot() != null && resource.getRoot().giGetElementType().hasListFeature(IVariantManagement.variantsFeature)) {
            for (IElement iElement : resource.getRoot().giGetList(IVariantManagement.variantsFeature).getElements()) {
                IVariant variant = (IVariant)iElement;
                if (!variant.getName(null).equalsIgnoreCase(contextName)) continue;
                return variant;
            }
        }
        return null;
    }

    public static Context getContextFromModel(String contextName, IbeeResource resource) {
        Context context = new Context();
        context.setName(contextName);
        if (resource == null) {
            return context;
        }
        IVariant contextInModel = null;
        if (resource.getRoot() != null && resource.getRoot().giGetElementType().hasListFeature(IVariantManagement.variantsFeature)) {
            for (IElement iElement : resource.getRoot().giGetList(IVariantManagement.variantsFeature).getElements()) {
                IVariant variant = (IVariant)iElement;
                if (!variant.getName(null).equalsIgnoreCase(contextName)) continue;
                contextInModel = variant;
                break;
            }
        }
        if (contextInModel == null) {
            return context;
        }
        context.getValue(Variant.class).getAttributeAssignments().clear();
        for (IAttributeAssignment iAttributeAssignment : contextInModel.getAssignments()) {
            AttributeAssignment assignment = new AttributeAssignment();
            assignment.setAttributePattern(iAttributeAssignment.getAttributePattern(null));
            assignment.setObjectPattern(iAttributeAssignment.getObjectPattern(null));
            assignment.setValue(iAttributeAssignment.getValue(null));
            context.getValue(Variant.class).getAttributeAssignments().add(assignment);
        }
        return context;
    }

    public static void putContextToModel(Context context, IbeeResource resource) {
        if (resource == null) {
            return;
        }
        IVariant contextInModel = null;
        if (resource.getRoot() != null && resource.getRoot().giGetElementType().hasListFeature(IVariantManagement.variantsFeature)) {
            for (IElement iElement : resource.getRoot().giGetList(IVariantManagement.variantsFeature).getElements()) {
                IVariant variant = (IVariant)iElement;
                if (!variant.getName(null).equalsIgnoreCase(context.getName())) continue;
                contextInModel = variant;
                break;
            }
        }
        if (contextInModel == null) {
            contextInModel = (IVariant)resource.create(IVariant.type);
            contextInModel.setName(context.getName());
            resource.getRoot().giGetList(IVariantManagement.variantsFeature).addElement(contextInModel);
        } else {
            contextInModel.clearAssignments();
        }
        for (AttributeAssignment attributeAssignment : context.getValue(Variant.class).getAttributeAssignments()) {
            IAttributeAssignment assignmentInModel = (IAttributeAssignment)resource.create(IAttributeAssignment.type);
            assignmentInModel.setAttributePattern(attributeAssignment.getAttributePattern());
            assignmentInModel.setObjectPattern(attributeAssignment.getObjectPattern());
            assignmentInModel.setValue(attributeAssignment.getValue());
            contextInModel.addAssignment(assignmentInModel);
        }
    }

    public static IAttributeFeature getAttributeFeatureFromPattern(String pattern) {
        String[] args = pattern.split(":");
        if (args.length != 3) {
            return null;
        }
        String domainName = args[0];
        String elementTypeName = args[1];
        String attributeName = args[2];
        IDomain domain = DomainRegistry.getDomain(domainName);
        if (domain == null) {
            return null;
        }
        IElementType<?> elementType = domain.getType(elementTypeName);
        if (elementType == null) {
            return null;
        }
        return elementType.getAttributeFeature(attributeName);
    }

    public static String getPatternFromAttributeFeature(IAttributeFeature feature) {
        if (feature == null) {
            return null;
        }
        IElementType<?> elementType = feature.getElementType();
        if (elementType == null) {
            return null;
        }
        IDomain domain = elementType.getDomain();
        if (domain == null) {
            return null;
        }
        String domainName = domain.getName();
        String elementTypeName = elementType.getName();
        String attributeName = feature.getName();
        return domainName + ":" + elementTypeName + ":" + attributeName;
    }
}

