/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.GlobalKeyCreator;
import net.edgemind.ibee.core.resource.KeyFeatureValueGetter;
import net.edgemind.ibee.util.string.StringUtil;

public class GlobalKey<T extends IElement> {
    private Map<String, String> data = new LinkedHashMap<String, String>();
    private IElementType<T> type;

    public static <T extends IElement> GlobalKey<T> createFrom(T e) {
        GlobalKeyCreator keyCreator = new GlobalKeyCreator();
        return keyCreator.createGlobalKey(e);
    }

    public static <T extends IElement> GlobalKey<T> createFrom(T element, IElement changedElement, IFeature keyFeature, Object oldValue) {
        GlobalKeyCreator keyCreator = new GlobalKeyCreator();
        KeyFeatureValueGetter valueGetter = new KeyFeatureValueGetter();
        valueGetter.setReplacement(changedElement, keyFeature, oldValue);
        String value = valueGetter.getFeatureValue(keyFeature, element);
        keyCreator.addReplacement(keyFeature, value);
        return keyCreator.createGlobalKey(element);
    }

    public static <T extends IElement> GlobalKey<T> createFrom(IElementType<T> type) {
        GlobalKey<T> key = new GlobalKey<T>(type);
        return key;
    }

    public static <T extends IElement> GlobalKey<T> createFrom(IElementType<T> type, GlobalKey<?> other) {
        GlobalKey<T> key = new GlobalKey<T>(type);
        key.importData(other);
        return key;
    }

    public boolean isEmpty() {
        for (String key : this.data.keySet()) {
            if (this.data.get(key) == null || this.data.get(key).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public GlobalKey(IElementType<T> type) {
        this.type = type;
    }

    public IElementType<T> getType() {
        return this.type;
    }

    public void setType(IElementType<T> type) {
        this.type = type;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void importData(GlobalKey<?> other) {
        this.data.clear();
        this.data.putAll(other.getData());
    }

    public GlobalKey<T> putRaw(IAttributeFeature attr, Object rawValue) {
        IType<?> type = attr.getType();
        String value = type.toString(rawValue);
        this.put(attr, value);
        return this;
    }

    public GlobalKey<T> put(IAttributeFeature attr, String value) {
        this.put(attr.getName(), value, attr.isCaseInSensitive());
        return this;
    }

    GlobalKey<T> put(String attr, String value, boolean caseInSenstitive) {
        if (value == null) {
            value = "";
        }
        if (caseInSenstitive) {
            value = value.toLowerCase();
        }
        this.data.put(GlobalKey.getKey(attr), value);
        return this;
    }

    public String get(IAttributeFeature attr) {
        return this.data.get(GlobalKey.getKey(attr));
    }

    public boolean matches(T el) {
        for (String attr : this.data.keySet()) {
            String value;
            IAttributeFeature attrFeature = el.giGetElementType().getAttributeFeature(attr);
            if (attrFeature == null) {
                return false;
            }
            String keyValue = this.data.get(attr);
            if (this.equals(keyValue, value = el.giGetAttribute(attr), attrFeature.isCaseInSensitive())) continue;
            return false;
        }
        return true;
    }

    private boolean equals(String s1, String s2, boolean caseInSensitive) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        if (caseInSensitive) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public int compareToEquals(GlobalKey<?> key2) {
        if (this.type != key2.type) {
            return this.type.getName().compareToIgnoreCase(key2.type.getName());
        }
        for (String attr : this.data.keySet()) {
            String value1 = this.data.get(attr);
            String value2 = key2.getData().get(attr);
            int cmp = this.isCaseInSensitive(attr) ? value1.compareToIgnoreCase(value2) : value1.compareTo(value2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static String getKey(IFeature feature) {
        return GlobalKey.getKey(feature.getName());
    }

    private static String getKey(String feature) {
        return feature.toLowerCase();
    }

    public int hashCode() {
        return this.toString(true, true).hashCode();
    }

    public String toDataString() {
        return this.toString(false, true);
    }

    public String toDataHash() {
        return StringUtil.sha256((String)this.toDataString());
    }

    public String toString(boolean encodeType, boolean encodeData) {
        if (this.data.size() == 1) {
            String attr = this.data.keySet().iterator().next();
            Object value = this.data.values().iterator().next();
            if (this.isCaseInSensitive(attr)) {
                value = ((String)value).toLowerCase();
            }
            if (encodeType && this.type != null) {
                value = this.type.getName() + (String)value;
            }
            return value;
        }
        StringBuffer buf = new StringBuffer();
        if (encodeType && this.type != null) {
            buf.append(this.type.getName());
        }
        if (encodeData) {
            for (String attr : StringUtil.performStringSort(this.data.keySet())) {
                buf.append(attr);
                buf.append("=");
                String value = this.data.get(attr);
                if (this.isCaseInSensitive(attr)) {
                    value = value.toLowerCase();
                }
                buf.append(value);
            }
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof GlobalKey) {
            GlobalKey key2 = (GlobalKey)o;
            if (this.type != key2.type) {
                return false;
            }
            for (String attr : this.data.keySet()) {
                String value1 = this.data.get(attr);
                String value2 = key2.getData().get(attr);
                int cmp = this.isCaseInSensitive(attr) ? value1.compareToIgnoreCase(value2) : value1.compareTo(value2);
                if (cmp == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCaseInSensitive(String featureName) {
        if (this.type == null) {
            return false;
        }
        IFeature feature = this.type.getFeature(featureName);
        if (feature instanceof IAttributeFeature) {
            return ((IAttributeFeature)feature).isCaseInSensitive();
        }
        return false;
    }
}

