/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource;

import net.edgemind.ibee.core.resource.FileResource;
import net.edgemind.ibee.core.resource.GlobalHashResource;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.Resource;
import net.edgemind.ibee.core.resource.impl.FileResourceImpl;
import net.edgemind.ibee.core.resource.impl.GlobalHashIbeeResourceImpl;
import net.edgemind.ibee.core.resource.type.FileResourceType;
import net.edgemind.ibee.core.resource.type.IResourceType;
import net.edgemind.ibee.core.resource.type.IbeeResourceType;

public class ResourceFactory {
    private static ResourceFactory instance = null;

    public static ResourceFactory getInstance() {
        if (instance == null) {
            instance = new ResourceFactory();
        }
        return instance;
    }

    public GlobalHashResource createGlobalHashIbeeResource() {
        GlobalHashIbeeResourceImpl resource = new GlobalHashIbeeResourceImpl();
        return resource;
    }

    public IbeeResource createIbeeResource() {
        return this.createGlobalHashIbeeResource();
    }

    public FileResource createFileResource() {
        return new FileResourceImpl();
    }

    public Resource createResource(IResourceType resourceType) {
        if (resourceType == null) {
            throw new IllegalArgumentException("resource type must not be null");
        }
        if (resourceType == IbeeResourceType.getInstance()) {
            return this.createIbeeResource();
        }
        if (resourceType == FileResourceType.getInstance()) {
            return this.createFileResource();
        }
        throw new IllegalArgumentException("unknown resource type " + String.valueOf(resourceType));
    }
}

