/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.edit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.edgemind.ibee.core.command.ExecutionException;
import net.edgemind.ibee.core.command.ICommandDate;
import net.edgemind.ibee.core.command.ICommandMessage;
import net.edgemind.ibee.core.command.IUndoRedoCommand;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IContainer;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceModificationListener;
import net.edgemind.ibee.core.resource.edit.ElementCreationAction;
import net.edgemind.ibee.core.resource.edit.ElementDeletionAction;
import net.edgemind.ibee.core.resource.edit.ElementModificationAction;
import net.edgemind.ibee.core.resource.edit.IRecordableAction;

public abstract class RecordCommand
implements IUndoRedoCommand,
ICommandMessage,
ICommandDate {
    private static final long serialVersionUID = 1L;
    private IbeeResource res;
    private String message = "";
    private Date date = null;
    private List<IRecordableAction> actionList = new ArrayList<IRecordableAction>();
    static Set<IbeeResource> currentlyRecording = new HashSet<IbeeResource>();

    protected abstract void executeRecorded() throws ExecutionException;

    public RecordCommand(IbeeResource resource) {
        this.res = resource;
    }

    public RecordCommand() {
    }

    public RecordCommand(IbeeResource resource, String message) {
        this.res = resource;
        this.message = message;
    }

    public void setResource(IbeeResource resource) {
        this.res = resource;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void execute() throws ExecutionException {
        block7: {
            block8: {
                recordListener = null;
                try {
                    this.date = new Date();
                    if (!RecordCommand.currentlyRecording.contains(this.res)) {
                        recordListener = this.createResourceListener();
                        this.res.addModificationListener(recordListener);
                        RecordCommand.currentlyRecording.add(this.res);
                        if (this.res.getLibraries() != null) {
                            for (IbeeLibrary lib : this.res.getLibraries()) {
                                libRes = lib.getResource();
                                if (libRes == null) continue;
                                libRes.addModificationListener(recordListener);
                            }
                        }
                    }
                    this.executeRecorded();
                }
                finally {
                    if (recordListener == null) break block7;
                    RecordCommand.currentlyRecording.remove(this.res);
                    if (this.res.getLibraries() == null) break block8;
                    ** for (lib : this.res.getLibraries())
                }
lbl-1000:
                // 1 sources

                {
                    libRes = lib.getResource();
                    if (libRes == null) continue;
                    libRes.removeModificationListener(recordListener);
                    continue;
                }
            }
            this.res.removeModificationListener(recordListener);
        }
    }

    private ResourceModificationListener createResourceListener() {
        ResourceModificationListener recordListener = new ResourceModificationListener(){

            @Override
            public void modified(IElement element, IFeature feature, Object oldValue, Object newValue) {
                ElementModificationAction action = new ElementModificationAction(element, feature, oldValue, newValue);
                RecordCommand.this.actionList.add(action);
            }

            @Override
            public void added(IElement element) {
                ElementCreationAction action = new ElementCreationAction(element);
                RecordCommand.this.actionList.add(action);
            }

            @Override
            public void removed(IElement element) {
                ElementDeletionAction action = new ElementDeletionAction(element);
                RecordCommand.this.actionList.add(action);
            }
        };
        return recordListener;
    }

    @Override
    public void undo() {
        int index = this.actionList.size() - 1;
        while (index >= 0) {
            IRecordableAction action = this.actionList.get(index);
            if (action instanceof ElementModificationAction) {
                this.undoElementModification((ElementModificationAction)action);
            } else if (action instanceof ElementDeletionAction) {
                this.undoElementDeletion((ElementDeletionAction)action);
            } else if (action instanceof ElementCreationAction) {
                this.undoElementCreation((ElementCreationAction)action);
            }
            --index;
        }
    }

    @Override
    public void redo() {
        int index = 0;
        while (index < this.actionList.size()) {
            IRecordableAction action = this.actionList.get(index);
            if (action instanceof ElementModificationAction) {
                this.redoElementModification((ElementModificationAction)action);
            } else if (action instanceof ElementDeletionAction) {
                this.redoElementDeletion((ElementDeletionAction)action);
            } else if (action instanceof ElementCreationAction) {
                this.redoElementCreation((ElementCreationAction)action);
            }
            ++index;
        }
    }

    private void merge(List<Long> curretIds, List<Long> from, List<Long> to) {
        boolean contained;
        if (from == null) {
            from = new ArrayList<Long>();
        }
        if (to == null) {
            to = new ArrayList<Long>();
        }
        for (long toId : to) {
            contained = from.contains(toId);
            if (contained || curretIds.contains(toId)) continue;
            curretIds.add(toId);
        }
        for (long fromId : from) {
            int currentIndex;
            contained = to.contains(fromId);
            if (contained || (currentIndex = curretIds.indexOf(fromId)) < 0) continue;
            curretIds.remove(currentIndex);
        }
    }

    private void undoElementModification(ElementModificationAction action) {
        long elementId = action.getElement();
        IElement element = action.getResource().getObject(elementId);
        if (element == null) {
            return;
        }
        IFeature feature = action.getFeature();
        if (feature instanceof IAttributeFeature) {
            element.giSetAttribute((IAttributeFeature)feature, (String)action.getOldValue());
        }
        if (feature instanceof IListFeature) {
            List ids;
            ListHandleImpl list = (ListHandleImpl)element.giGetList((IListFeature)feature);
            if (((IListFeature)feature).isContainment()) {
                if (list instanceof IContainer) {
                    ids = list.getAllElementIds();
                    this.merge(ids, (List)action.getNewValue(), (List)action.getOldValue());
                } else {
                    ids = (List)action.getOldValue();
                }
                for (Long id : ids) {
                    IElement e = action.getResource().getObject(id);
                    if (e == null) continue;
                    ((AElementImpl)e).giSetParentId(elementId, feature);
                }
            } else {
                ids = (List)action.getOldValue();
            }
            list.setAllElementsByIdInject(ids, true);
        }
        if (feature instanceof IElementFeature) {
            Long id;
            if (((IElementFeature)feature).isContainment()) {
                IElement e;
                id = (Long)action.getOldValue();
                if (id != null && (e = action.getResource().getObject(id)) != null) {
                    ((AElementImpl)e).giSetParentId(elementId, feature);
                }
            } else {
                id = (Long)action.getOldValue();
            }
            ElementHandleImpl elementHandle = (ElementHandleImpl)element.giGetElement((IElementFeature)feature);
            elementHandle.setElementByIdInject(id, true);
        }
    }

    private void redoElementModification(ElementModificationAction action) {
        long elementId = action.getElement();
        IElement element = action.getResource().getObject(elementId);
        if (element == null) {
            return;
        }
        IFeature feature = action.getFeature();
        if (feature instanceof IAttributeFeature) {
            element.giSetAttribute((IAttributeFeature)feature, (String)action.getNewValue());
        }
        if (feature instanceof IListFeature) {
            List ids;
            ListHandleImpl list = (ListHandleImpl)element.giGetList((IListFeature)feature);
            if (((IListFeature)feature).isContainment()) {
                if (list instanceof IContainer) {
                    ids = list.getAllElementIds();
                    this.merge(ids, (List)action.getOldValue(), (List)action.getNewValue());
                } else {
                    ids = (List)action.getNewValue();
                }
                for (Long id : ids) {
                    IElement e = action.getResource().getObject(id);
                    if (e == null) continue;
                    ((AElementImpl)e).giSetParentId(elementId, feature);
                }
            } else {
                ids = (List)action.getNewValue();
            }
            list.setAllElementsByIdInject(ids, true);
        }
        if (feature instanceof IElementFeature) {
            Long id;
            ElementHandleImpl elementHandle = (ElementHandleImpl)element.giGetElement((IElementFeature)feature);
            if (((IElementFeature)feature).isContainment()) {
                IElement e;
                id = (Long)action.getNewValue();
                if (id != null && (e = action.getResource().getObject(id)) != null) {
                    ((AElementImpl)e).giSetParentId(elementId, feature);
                }
            } else {
                id = (Long)action.getNewValue();
            }
            elementHandle.setElementByIdInject(id, true);
        }
    }

    private void undoElementDeletion(ElementDeletionAction action) {
        action.getResource().putObject(action.getElement());
    }

    private void undoElementCreation(ElementCreationAction action) {
    }

    private void redoElementDeletion(ElementDeletionAction action) {
    }

    private void redoElementCreation(ElementCreationAction action) {
        action.getResource().putObject(action.getElement());
    }

    @Override
    public boolean isEmpty() {
        return this.actionList.size() == 0;
    }

    public List<IRecordableAction> getRecordedActions() {
        return this.actionList;
    }
}

