/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import jsinterop.annotations.JsType;
import net.edgemind.ibee.core.iml.domain.IBasicReferenceType;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.iml.domain.ImfReferenceType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.ImfComponent;
import net.edgemind.ibee.core.iml.model.ImfIdComponent;
import net.edgemind.ibee.core.iml.model.ImfNamedComponent;
import net.edgemind.ibee.core.iml.model.ImfNamedElement;
import net.edgemind.ibee.core.iml.model.ImfReference;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.GlobalHashResource;
import net.edgemind.ibee.core.resource.GlobalKey;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.impl.HashStorage;
import net.edgemind.ibee.core.resource.impl.IbeeResourceImpl;
import net.edgemind.ibee.core.util.Selection;
import net.edgemind.ibee.util.misc.IFilter;

@JsType(namespace="ibee")
public class GlobalHashIbeeResourceImpl
extends IbeeResourceImpl
implements GlobalHashResource {
    private HashStorage<IElementType<?>, GlobalKey<?>, IElement> storage = new HashStorage();
    private Map<IElementType<?>, Set<IElement>> globalElements;
    private IbeeResource parent;

    public GlobalHashIbeeResourceImpl() {
        this.storage.setStringifier(globalKey -> globalKey.toDataString());
        this.globalElements = new HashMap();
    }

    @Override
    public IbeeResource getMainResource() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    private boolean isGlobal(IElement element) {
        return element.isGlobal();
    }

    private boolean isGlobal(IElementType<? extends IElement> type) {
        return type.isGlobal();
    }

    private boolean isKeyed(IElement element) {
        return element.isKeyed();
    }

    @Override
    public void setParent(IbeeResource resource) {
        this.parent = resource;
    }

    @Override
    public void notifySetParent(IElement element) {
        if (this.isActive(element)) {
            this.addGlobalElements(element, true);
            this.updateKey(element, true);
        }
    }

    @Override
    public void notifyUnsetParent(IElement element) {
        if (!this.isActive(element)) {
            this.removeGlobalElements(element, true);
            this.removeKey(element, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(IElement element, IFeature feature, Object oldValue, Object newValue) {
        if (this.isActive(element) && feature.isKey()) {
            HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
            synchronized (hashStorage) {
                IFeature currentFeature = feature;
                IElement currentElement = element;
                while (currentElement != null && currentFeature != null && currentFeature.isKey()) {
                    if (this.isKeyed(currentElement)) {
                        this.removeElementKey(currentElement, element, feature, oldValue);
                        this.storeElementKey(currentElement);
                    }
                    currentFeature = currentElement.giGetParentFeature();
                    currentElement = currentElement.giGetParent();
                }
            }
        }
        super.notify(element, feature, oldValue, newValue);
    }

    private void updateKey(IElement element, boolean rec) {
        if (this.isKeyed(element)) {
            this.storeElementKey(element);
        }
        if (rec) {
            this.applyForChildren(element, child -> this.updateKey((IElement)child, rec));
        }
    }

    private void removeKey(IElement element, boolean rec) {
        if (this.isKeyed(element)) {
            this.removeElementKey(element);
        }
        if (rec) {
            this.applyForChildren(element, child -> this.removeKey((IElement)child, rec));
        }
    }

    private void applyForChildren(IElement e, Consumer<IElement> consumer) {
        for (IListFeature<IElement> iListFeature : e.giGetElementType().getListFeatures()) {
            IListHandle<IElement> listHandle;
            if (!iListFeature.isContainment() || (listHandle = e.giGetList(iListFeature)) == null) continue;
            listHandle.forEach(child -> consumer.accept((IElement)child));
        }
        for (IElementFeature iElementFeature : e.giGetElementType().getElementFeatures()) {
            Object child2;
            IElementHandle elHandle;
            if (!iElementFeature.isContainment() || (elHandle = e.giGetElement(iElementFeature)) == null || (child2 = elHandle.getElement(false)) == null) continue;
            consumer.accept((IElement)child2);
        }
    }

    private void addGlobalElements(IElement element, boolean rec) {
        if (this.isGlobal(element)) {
            IElementType<? extends IElement> type = element.giGetElementType();
            Set<IElement> set = this.globalElements.get(type);
            if (set == null) {
                set = new HashSet<IElement>();
                this.globalElements.put(type, set);
            }
            set.add(element);
        }
        if (rec) {
            this.applyForChildren(element, child -> this.addGlobalElements((IElement)child, rec));
        }
    }

    private void removeGlobalElements(IElement element, boolean rec) {
        IElementType<? extends IElement> type;
        Set<IElement> set;
        if (rec) {
            this.applyForChildren(element, child -> this.removeGlobalElements((IElement)child, rec));
        }
        if (this.isGlobal(element) && (set = this.globalElements.get(type = element.giGetElementType())) != null) {
            set.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IElement> T resolve(GlobalKey<T> globalKey) {
        IElementType<T> type = globalKey.getType();
        IElement el = null;
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            el = this.storage.getFirst(type, globalKey);
        }
        if (el == null) {
            for (IbeeLibrary lib : this.getLibraries()) {
                IbeeResource res = lib.getResource();
                if (res == null) continue;
                el = res.resolve(globalKey);
            }
        }
        return (T)el;
    }

    private void storeElementKey(IElement element) {
        if (this.isKeyed(element)) {
            GlobalKey<IElement> globalKey = this.createKey(element);
            this.storeElementKey(element, globalKey);
            if (element instanceof ImfNamedComponent && !this.isUniqueByName(element.giGetElementType())) {
                ImfNamedComponent namedComponent = (ImfNamedComponent)element;
                GlobalKey namedKey = this.createNamedKey((ImfComponentType)namedComponent.giGetElementType(), namedComponent.getName());
                this.storeElementKey(element, namedKey);
            }
            if (element instanceof ImfIdComponent && !this.isUniqueById(element.giGetElementType())) {
                ImfIdComponent idComponent = (ImfIdComponent)element;
                GlobalKey idKey = this.createIdKey((ImfComponentType)idComponent.giGetElementType(), idComponent.getId());
                this.storeElementKey(element, idKey);
            }
        }
    }

    private void storeElementKey(IElement element, GlobalKey<? extends IElement> globalKey) {
        if (!globalKey.isEmpty() && this.isKeyed(element)) {
            this.storage.add(element.giGetElementType(), globalKey, element);
        }
    }

    private void removeElementKey(IElement element) {
        if (this.isKeyed(element)) {
            GlobalKey<IElement> globalKey = this.createKey(element);
            this.removeElementKey(element, globalKey);
            if (element instanceof ImfNamedComponent && !this.isUniqueByName(element.giGetElementType())) {
                String name = ((ImfNamedComponent)element).getName();
                GlobalKey namedKey = this.createNamedKey((ImfComponentType)((ImfNamedComponent)element).giGetElementType(), name);
                this.removeElementKey(element, namedKey);
            }
            if (element instanceof ImfIdComponent && !this.isUniqueById(element.giGetElementType())) {
                ImfIdComponent idComponent = (ImfIdComponent)element;
                GlobalKey idKey = this.createIdKey((ImfComponentType)idComponent.giGetElementType(), idComponent.getId());
                this.removeElementKey(element, idKey);
            }
        }
    }

    private void removeElementKey(IElement element, IElement changedElement, IFeature feature, Object oldValue) {
        if (this.isKeyed(element)) {
            GlobalKey<IElement> globalKey = this.createKey(element, changedElement, feature, oldValue);
            this.removeElementKey(changedElement, globalKey);
            if (feature == ImfNamedComponent.nameFeature && element instanceof ImfNamedComponent && !this.isUniqueByName(element.giGetElementType())) {
                String name = (String)oldValue;
                GlobalKey namedKey = this.createNamedKey((ImfComponentType)((ImfNamedComponent)element).giGetElementType(), name);
                this.removeElementKey(changedElement, namedKey);
            }
            if (feature == ImfIdComponent.idFeature && element instanceof ImfIdComponent && !this.isUniqueById(element.giGetElementType())) {
                ImfIdComponent idComponent = (ImfIdComponent)element;
                GlobalKey idKey = this.createIdKey((ImfComponentType)idComponent.giGetElementType(), idComponent.getId());
                this.removeElementKey(element, idKey);
            }
        }
    }

    private void removeElementKey(IElement element, GlobalKey<? extends IElement> globalKey) {
        if (this.isKeyed(element) && !globalKey.isEmpty()) {
            this.storage.remove(element.giGetElementType(), globalKey, element);
        }
    }

    private boolean isUniqueByName(IElementType<?> type) {
        if (type instanceof ImfComponentType && type.isNamed()) {
            return type.getKeyFeatures().size() == 1 && type.getKeyFeatures().get(0) == ImfNamedComponent.nameFeature;
        }
        return false;
    }

    private boolean isUniqueById(IElementType<?> type) {
        if (type instanceof ImfIdComponent) {
            return type.getKeyFeatures().size() == 1 && type.getKeyFeatures().get(0) == ImfIdComponent.idFeature;
        }
        return false;
    }

    @Override
    public Collection<IElement> getGlobalElements(boolean withLibs) {
        ArrayList<IElement> res = new ArrayList<IElement>();
        for (IElementType<?> type : this.globalElements.keySet()) {
            res.addAll((Collection<IElement>)this.globalElements.get(type));
        }
        if (withLibs) {
            this.doForAllLibs(lib -> {
                boolean bl2 = res.addAll(lib.getGlobalElements(withLibs));
            });
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IElement> Collection<T> getGlobalElements(GlobalKey<T> globalKey, boolean withInherited, boolean withLibs) {
        HashSet<T> set = new HashSet<T>();
        IElementType<T> type = globalKey.getType();
        HashStorage<IElementType<?>, GlobalKey<?>, IElement> hashStorage = this.storage;
        synchronized (hashStorage) {
            set.addAll((Set)this.storage.getElements(type, globalKey));
        }
        if (withInherited) {
            for (IElementType iElementType : this.storage.getKeys1()) {
                if (!iElementType.inherits(type)) continue;
                set.addAll((Set)this.storage.getElements(iElementType, globalKey));
            }
        }
        if (withLibs) {
            for (IbeeLibrary ibeeLibrary : this.getLibraries()) {
                IbeeResource res = ibeeLibrary.getResource();
                if (res == null) continue;
                set.addAll(((GlobalHashResource)res).getGlobalElements(globalKey, withInherited, false));
            }
        }
        return set;
    }

    @Override
    public <T extends IElement> Collection<T> getGlobalElements(IElementType<T> type, boolean withInherited, boolean withLibs, IFilter<T> filter) {
        HashSet<Object> set = new HashSet<Object>();
        if (withInherited) {
            for (IElementType<?> elType : this.globalElements.keySet()) {
                if (!elType.inherits(type)) continue;
                set.addAll(this.getGlobalElements(elType));
            }
        } else {
            set.addAll(this.getGlobalElements(type));
        }
        if (filter != null) {
            set.removeIf(e -> !filter.accept(e));
        }
        if (withLibs) {
            this.doForAllLibs(lib -> {
                boolean bl2 = set.addAll(lib.getGlobalElements(type, withInherited, false, filter));
            });
        }
        return set;
    }

    private <T extends IElement> Collection<T> getGlobalElements(IElementType<?> type) {
        List list = (List)((Object)this.globalElements.get(type));
        return list != null ? list : Collections.emptyList();
    }

    private void doForAllLibs(Consumer<IbeeResource> resourceConsumer) {
        for (IbeeLibrary lib : this.getLibraries()) {
            IbeeResource res = lib.getResource();
            if (res == null) continue;
            resourceConsumer.accept(res);
        }
    }

    private <T extends IElement> GlobalKey<T> createKey(T element, IElement changedElement, IFeature feature, Object oldValue) {
        GlobalKey<T> key = GlobalKey.createFrom(element, changedElement, feature, oldValue);
        return key;
    }

    private <T extends IElement> GlobalKey<T> createKey(T element) {
        GlobalKey<T> key = GlobalKey.createFrom(element);
        return key;
    }

    private <T extends ImfNamedComponent> GlobalKey<T> createNamedKey(ImfComponentType<T> componentType, String componentName) {
        if (componentName == null) {
            componentName = "";
        }
        GlobalKey<T> key = GlobalKey.createFrom(componentType);
        String value = componentName;
        if (ImfNamedElement.nameFeature.isCaseInSensitive()) {
            value = value.toLowerCase().trim();
        }
        key.put(ImfNamedElement.nameFeature, value);
        return key;
    }

    private <T extends ImfIdComponent> GlobalKey<T> createIdKey(ImfComponentType<T> componentType, Long componentId) {
        GlobalKey<T> key = GlobalKey.createFrom(componentType);
        String value = String.valueOf(componentId);
        key.put(ImfIdComponent.idFeature, value);
        return key;
    }

    @Override
    public Collection<ImfReference> getReferences(ImfComponent component) {
        IDomain domain = component.giGetResource().getDomain();
        HashSet<ImfReferenceType> relevantRefTypes = new HashSet<ImfReferenceType>();
        for (IElementType<?> type : domain.getTypes()) {
            if (type.isAbstract() || !type.isReferenceType()) continue;
            ImfReferenceType refType = (ImfReferenceType)type;
            if (refType.getTargetTypes().size() == 0) {
                relevantRefTypes.add(refType);
                continue;
            }
            for (IElementType<?> referencedType : refType.getTargetTypes()) {
                if (!component.giGetElementType().inherits(referencedType)) continue;
                relevantRefTypes.add(refType);
            }
        }
        HashSet<ImfReference> references = new HashSet<ImfReference>();
        GlobalKey<ImfComponent> targetKey = GlobalKey.createFrom(component);
        for (ImfReferenceType refType : relevantRefTypes) {
            ImfReference ref;
            if (refType instanceof IBasicReferenceType) {
                GlobalKey refKey = new GlobalKey(refType);
                refKey.importData(targetKey);
                references.addAll(this.getKeyedElements(refType, refKey));
                continue;
            }
            if (this.isGlobal(refType)) {
                for (IElement refEl : this.getGlobalElements(refType)) {
                    ref = (ImfReference)refEl;
                    if (ref.resolve() != component) continue;
                    references.add(ref);
                }
                continue;
            }
            for (IElement refEl : this.getAllObjects(refType, true)) {
                ref = (ImfReference)refEl;
                if (ref.resolve() != component) continue;
                references.add(ref);
            }
        }
        return references;
    }

    private Collection<IElement> getKeyedElements(IElementType<?> type, GlobalKey key) {
        return this.storage.getElements(type, key);
    }

    @Override
    public Collection<ImfComponent> getComponents(boolean withLibs) {
        ArrayList<ImfComponent> res = new ArrayList<ImfComponent>();
        for (IElementType<?> type : this.globalElements.keySet()) {
            if (!type.isComponentType()) continue;
            res.addAll(this.getGlobalElements(type));
        }
        if (withLibs) {
            this.doForAllLibs(lib -> {
                boolean bl2 = res.addAll(lib.getComponents(withLibs));
            });
        }
        return res;
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponents(ImfComponentType<T> componentType, String componentName) {
        return this.getComponents(componentType, componentName, false);
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponents(ImfComponentType<T> componentType, String componentName, boolean withLibs) {
        GlobalKey<T> namedKey = this.createNamedKey(componentType, componentName);
        return new Selection<T>(this.getGlobalElements(namedKey, componentType.isAbstract(), withLibs));
    }

    @Override
    public <T extends ImfComponent> Selection<T> getComponentsByType(ImfComponentType<T> componentType) {
        return this.getComponentsByType(componentType, false);
    }

    @Override
    public <T extends ImfComponent> Selection<T> getComponentsByType(ImfComponentType<T> componentType, boolean withLibs) {
        return new Selection<T>(this.getGlobalElements(componentType, componentType.isAbstract(), withLibs, null));
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponentsByName(String componentName) {
        return this.getComponentsByName(componentName, false);
    }

    @Override
    public <T extends ImfIdComponent> T getComponentById(ImfComponentType<T> componentType, Long componentId) {
        if (componentType.isIdBased()) {
            GlobalKey<T> idKey = this.createIdKey(componentType, componentId);
            Selection<T> sel = new Selection<T>(this.getGlobalElements(idKey, componentType.isAbstract(), false));
            return (T)((ImfIdComponent)sel.first());
        }
        return null;
    }

    @Override
    public <T extends ImfNamedComponent> Selection<T> getComponentsByName(String componentName, boolean withLibs) {
        Selection set = new Selection();
        for (IElementType<?> type : this.storage.getKeys1()) {
            if (!type.isNamed() || !type.isComponentType()) continue;
            GlobalKey<T> namedKey = this.createNamedKey((ImfComponentType)type, componentName);
            set.addAll(this.getGlobalElements(namedKey, type.isAbstract(), false));
        }
        if (withLibs) {
            this.doForAllLibs(lib -> set.addAll(lib.getComponentsByName(componentName, withLibs)));
        }
        return set;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.storage.clear();
    }
}

