/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class HashStorage<U, V, T> {
    private Map<U, Map<String, Object>> content = new HashMap<U, Map<String, Object>>();
    private Function<V, String> toStringFct = v -> v.toString();

    public void setStringifier(Function<V, String> fct) {
        this.toStringFct = fct;
    }

    public Collection<T> getElements(U key1, V key2) {
        if (!this.content.containsKey(key1)) {
            return Collections.emptySet();
        }
        return this.getElements(key1, this.toString(key2));
    }

    public Collection<T> getElements(U key1, String key2) {
        Collection<Object> res = null;
        if (this.content.containsKey(key1)) {
            Object obj = this.content.get(key1).get(key2);
            if (obj instanceof Collection) {
                res = (Collection)obj;
            } else if (obj != null) {
                res = new HashSet();
                res.add(obj);
            }
        }
        if (res == null) {
            res = Collections.emptySet();
        }
        return res;
    }

    public T getFirst(U key1, V key2) {
        if (this.content.containsKey(key1)) {
            Object obj = this.content.get(key1).get(this.toString(key2));
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                return !list.isEmpty() ? (T)list.iterator().next() : null;
            }
            return (T)obj;
        }
        return null;
    }

    public Set<U> getKeys1() {
        return this.content.keySet();
    }

    public Collection<T> getElements(U key1) {
        HashSet<T> set = new HashSet<T>();
        if (this.content.containsKey(key1)) {
            for (String nextSet : this.content.get(key1).keySet()) {
                set.addAll(this.getElements(key1, nextSet));
            }
        }
        return set;
    }

    public void add(U key1, V key2, T value) {
        String key2Str;
        Object obj;
        Map<String, Object> map = this.content.get(key1);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.content.put(key1, map);
        }
        if ((obj = map.get(key2Str = this.toString(key2))) == null) {
            map.put(key2Str, value);
        } else if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            list.add(value);
            map.put(key2Str, list);
        } else {
            HashSet<Object> list = new HashSet<Object>();
            list.add(obj);
            list.add(value);
            map.put(key2Str, list);
        }
    }

    public boolean remove(U key1, V key2, T value) {
        if (!this.content.containsKey(key1)) {
            return false;
        }
        String key2Str = this.toString(key2);
        return this.remove(key1, key2Str, value);
    }

    public boolean remove(U key1, String key2Str, T value) {
        Map<String, Object> map = this.content.get(key1);
        if (map == null) {
            return false;
        }
        boolean found = false;
        Object obj = map.get(key2Str);
        if (obj != null) {
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                found = list.remove(value);
                if (list.size() == 1) {
                    map.put(key2Str, list.iterator().next());
                }
            } else if (obj == value) {
                map.remove(key2Str);
                found = true;
            }
        }
        return found;
    }

    private String toString(V key) {
        return this.toStringFct.apply(key);
    }

    public void clear() {
        this.content.clear();
    }

    public void remove(U key1, T element) {
        Map<String, Object> map = this.content.get(key1);
        if (map == null) {
            return;
        }
        for (String key : new ArrayList<String>(map.keySet())) {
            this.remove(key1, key, element);
        }
    }

    public void printStorage() {
        System.out.println("Stored Elements:");
        for (U key : this.content.keySet()) {
            Map<String, Object> map = this.content.get(key);
            System.out.println(String.format("-Key : %s:", key));
            for (String key2 : map.keySet()) {
                Object obj = map.get(key2);
                int size = obj instanceof Collection ? ((Collection)obj).size() : (obj != null ? 1 : 0);
                System.out.println(String.format("--Entry %s: (%d elements)", key2.toString(), size));
            }
        }
    }
}

