/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.impl;

import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.core.resource.Resource;
import net.edgemind.ibee.core.resource.ResourceController;
import net.edgemind.ibee.core.resource.ResourceDescriptor;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.impl.ResourceDescriptorImpl;
import net.edgemind.ibee.core.resource.impl.ResourceImpl;
import net.edgemind.ibee.core.resource.url.URL;

public abstract class ResourceControllerImpl
implements ResourceController {
    protected Map<String, String> options = new HashMap<String, String>();
    private boolean optionsModified = false;
    protected ResourceDescriptor descriptor;

    protected abstract Resource createResource();

    protected abstract void readContent() throws ResourceException;

    protected abstract void writeContent() throws ResourceException;

    protected abstract void purgeContent();

    public ResourceControllerImpl(ResourceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void reload() throws ResourceException {
        this.close();
        this.open();
        this.read();
    }

    @Override
    public void write() throws ResourceException {
        if (this.descriptor.getResource() == null) {
            return;
        }
        this.writeContent();
    }

    @Override
    public boolean isOpen() {
        return this.getResource() != null;
    }

    @Override
    public void close() throws ResourceException {
        if (!this.isOpen()) {
            return;
        }
        this.getResource().dispose();
        this.setResource(null);
    }

    public Resource getResource() {
        return this.descriptor.getResource();
    }

    @Override
    public Resource getResource(boolean open) {
        if (this.getResource() == null && open) {
            this.open();
        }
        return this.getResource();
    }

    @Override
    public void open() {
        if (this.getResource() != null) {
            return;
        }
        Resource resource = this.createResource();
        ((ResourceImpl)resource).setURL(this.descriptor.getURL());
        resource.setVersion(this.descriptor.getVersion());
        this.setResource(resource);
    }

    @Override
    public void purge() {
        Resource resource = this.getResource(false);
        if (resource == null) {
            return;
        }
        this.purgeContent();
    }

    @Override
    public void setResource(Resource resource) {
        if (resource == this.getResource()) {
            return;
        }
        if (this.getResource() == null && resource != null) {
            ((ResourceImpl)resource).setURL(this.descriptor.getURL());
        }
        ((ResourceDescriptorImpl)this.descriptor).setResource(resource);
    }

    @Override
    public void read() throws ResourceException {
        this.getResource(true);
        this.readContent();
    }

    @Override
    public ResourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean hasOption(String key, String value, String defaultValue) {
        String current = this.options.get(key);
        if (current == null) {
            current = defaultValue;
        }
        if (value == null || current == null) {
            return value == current;
        }
        return current != null && current.equals(value);
    }

    @Override
    public void setOption(String key, String value) {
        if (this.options.get(key) != null && this.options.get(key).equals(value)) {
            return;
        }
        this.options.put(key, value);
        this.optionsModified = true;
    }

    public String getOption(String key) {
        return this.options.get(key);
    }

    protected boolean optionsModified() {
        return this.optionsModified;
    }

    protected void resetOptionsModified() {
        this.optionsModified = false;
    }

    @Override
    public URL getUrl() {
        ResourceDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            return descriptor.getURL();
        }
        return null;
    }
}

