/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IContent;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.reader.ParentCorrector;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.string.StringUtil;

public class BinaryIbeeResourceReaderMultiFile {
    public IbeeResource readModel(String resourceDir, IbeeResource resource) throws ResourceException {
        String indexFile;
        block5: {
            indexFile = resourceDir + File.separator + "index";
            if (FileUtil.fileExists((String)indexFile)) break block5;
            LogUtil.log("read resource '" + String.valueOf(resource.getURL()) + "': not found on hard disk, nothing read", LogLevel.WARNING);
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(indexFile));
            long rootId = -1L;
            while (reader.ready()) {
                int index;
                String next = reader.readLine().trim();
                if (next.isEmpty() || (index = next.indexOf("=")) < 0) continue;
                String key = next.substring(0, index).trim();
                String value = next.substring(index + 1).trim();
                if (!key.equalsIgnoreCase("root")) continue;
                rootId = StringUtil.toLong((String)value, (Long)-1L);
            }
            reader.close();
            if (rootId == -1L) {
                LogUtil.log("no root id found for resource " + resourceDir);
                return resource;
            }
            this.parseElement(rootId, resource, resourceDir);
            resource.setRoot(resource.getObject(rootId));
            ParentCorrector corrector = new ParentCorrector();
            corrector.correct(resource);
            return resource;
        }
        catch (IOException io) {
            throw new ResourceException(io);
        }
    }

    private String readString(InputStream in) throws IOException {
        int l = this.readInt(in);
        byte[] bytes = new byte[l];
        in.read(bytes);
        return new String(bytes);
    }

    private long readLong(InputStream in) throws IOException {
        long v = 0L;
        int i = 0;
        while (i < 8) {
            v <<= 8;
            v += (long)in.read();
            ++i;
        }
        return v;
    }

    private int readInt(InputStream in) throws IOException {
        int v = 0;
        int i = 0;
        while (i < 4) {
            v <<= 8;
            v += in.read();
            ++i;
        }
        return v;
    }

    private void parseElement(long id, IbeeResource resource, String resourceDir) throws IOException {
        File file = new File(resourceDir + File.separator + id + ".dat");
        IElement element = this.parseElement(file.getAbsolutePath());
        if (element != null) {
            resource.putObject(element);
            for (IElementFeature<IElement> iElementFeature : element.giGetElementType().getElementFeatures()) {
                long containedId;
                if (!iElementFeature.isContainment() || (containedId = ((ElementHandleImpl)element.giGetElement(iElementFeature)).getElementId()) == -1L) continue;
                this.parseElement(containedId, resource, resourceDir);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                if (!iListFeature.isContainment()) continue;
                for (long containedId : ((ListHandleImpl)element.giGetList(iListFeature)).getAllElementIds()) {
                    if (containedId == -1L) continue;
                    this.parseElement(containedId, resource, resourceDir);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IElement parseElement(String filePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = FileUtil.openInputStream((File)new File(filePath));){
            String domainName = this.readString(in);
            IDomain domain = DomainRegistry.getDomain(domainName);
            if (domain == null) {
                LogUtil.error("ModelReader:parseElement:unkown domain '" + domainName + "'");
                return null;
            }
            int typeIndex = this.readInt(in);
            IElementType<?> type = domain.getTypes().get(typeIndex);
            if (type == null) {
                LogUtil.error("ModelReader:parseElement:unkown type ");
                return null;
            }
            Object element = domain.create(type);
            ((AElementImpl)element).giSetId(this.readLong(in));
            this.readLong(in);
            while (true) {
                IContent handle;
                IFeature feature;
                int index;
                if (in.available() <= 0) {
                    return element;
                }
                int featureType = this.readInt(in);
                if (featureType == 1) {
                    index = this.readInt(in);
                    feature = type.getElementFeatures().get(index);
                    handle = (ElementHandleImpl)element.giGetElement(feature);
                    long refId = this.readLong(in);
                    ((ElementHandleImpl)handle).setElementByIdInject(refId, false);
                }
                if (featureType == 2) {
                    index = this.readInt(in);
                    feature = type.getListFeatures().get(index);
                    handle = (ListHandleImpl)element.giGetList(feature);
                    int cnt = this.readInt(in);
                    ArrayList<Long> refIds = new ArrayList<Long>();
                    int i = 0;
                    while (true) {
                        if (i >= cnt) {
                            ((ListHandleImpl)handle).setAllElementsByIdInject(refIds, false);
                            break;
                        }
                        refIds.add(this.readLong(in));
                        ++i;
                    }
                }
                if (featureType != 3) continue;
                index = this.readInt(in);
                feature = type.getAttributeFeatures().get(index);
                String value = this.readString(in);
                element.giSetAttribute((IAttributeFeature)feature, value);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

