/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.reader.ParentCorrector;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlIbeeResourceReaderMultiFile {
    IbeeResource resource;

    public IbeeResource readModel(String resourceDir, IbeeResource resource) throws ResourceException {
        String indexFile;
        block5: {
            this.resource = resource;
            indexFile = resourceDir + File.separator + "index";
            if (FileUtil.fileExists((String)indexFile)) break block5;
            LogUtil.log("read resource '" + String.valueOf(resource.getURL()) + "': not found on hard disk, nothing read", LogLevel.WARNING);
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(indexFile));
            long rootId = -1L;
            while (reader.ready()) {
                int index;
                String next = reader.readLine().trim();
                if (next.isEmpty() || (index = next.indexOf(":")) < 0) continue;
                String key = next.substring(0, index).trim();
                String value = next.substring(index + 1).trim();
                if (!key.equalsIgnoreCase("root")) continue;
                rootId = StringUtil.toLong((String)value, (Long)-1L);
            }
            reader.close();
            if (rootId == -1L) {
                LogUtil.log("no root id found for resource " + resourceDir);
                return resource;
            }
            this.parseElement(rootId, resourceDir);
            resource.setRoot(resource.getObject(rootId));
            ParentCorrector corrector = new ParentCorrector();
            corrector.correct(resource);
            return resource;
        }
        catch (IOException io) {
            throw new ResourceException(io);
        }
    }

    private void parseElement(long id, String resourceDir) throws IOException {
        File file = new File(resourceDir + File.separator + id + ".xml");
        IElement element = this.parseElement(file.getAbsolutePath());
        if (element != null) {
            this.resource.putObject(element);
            for (IElementFeature<IElement> iElementFeature : element.giGetElementType().getElementFeatures()) {
                long containedId;
                if (!iElementFeature.isContainment() || (containedId = ((ElementHandleImpl)element.giGetElement(iElementFeature)).getElementId()) == -1L) continue;
                this.parseElement(containedId, resourceDir);
            }
            for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
                if (!iListFeature.isContainment()) continue;
                for (long containedId : ((ListHandleImpl)element.giGetList(iListFeature)).getAllElementIds()) {
                    if (containedId == -1L) continue;
                    this.parseElement(containedId, resourceDir);
                }
            }
        }
    }

    private IElement parseElement(String xmlPath) throws IOException {
        Document document = null;
        IElement element = null;
        try {
            document = XmlUtil.readXmlFile((String)xmlPath);
            Element xmlElement = document.getDocumentElement();
            String domainName = xmlElement.getAttribute("domain");
            IDomain domain = DomainRegistry.getDomain(domainName);
            if (domain == null) {
                LogUtil.error("ModelReader:parseElement:unkown domain '" + domainName + "'");
                return null;
            }
            String typeName = xmlElement.getAttribute("type");
            IElementType<?> type = domain.getType(typeName);
            if (type == null) {
                LogUtil.error("ModelReader:parseElement:unkown type '" + typeName + "'");
                return null;
            }
            element = this.createElement(type, domain);
            String idString = xmlElement.getAttribute("id");
            if (idString != null && !idString.isEmpty()) {
                long id = StringUtil.toLong((String)idString, (Long)-1L);
                ((AElementImpl)element).giSetId(id);
            }
            List xmlAttributes = XmlUtil.getChildrenByTagName((String)"attribute", (Element)xmlElement);
            for (Element xmlAttribute : xmlAttributes) {
                element.giSetAttribute(xmlAttribute.getAttribute("name"), xmlAttribute.getTextContent());
            }
            List xmlLists = XmlUtil.getChildrenByTagName((String)"list", (Element)xmlElement);
            for (Element xmlList : xmlLists) {
                String[] args;
                ListHandleImpl listHandle;
                String listName = XmlUtil.getAttribute((Element)xmlList, (String)"name", (boolean)false);
                String idSequence = XmlUtil.getAttribute((Element)xmlList, (String)"ids", (boolean)true);
                if (idSequence == null || idSequence.isEmpty() || (listHandle = (ListHandleImpl)element.giGetList(listName)) == null) continue;
                ArrayList<Long> ids = new ArrayList<Long>();
                String[] stringArray = args = idSequence.split(",");
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    long id = StringUtil.toLong((String)arg, (Long)-1L);
                    if (id != -1L) {
                        ids.add(id);
                    }
                    ++n2;
                }
                listHandle.setAllElementsByIdInject(ids, false);
            }
            List xmlChilds = XmlUtil.getChildrenByTagName((String)"element", (Element)xmlElement);
            for (Element xmlChild : xmlChilds) {
                ElementHandleImpl elementHandle;
                long id;
                String childName = XmlUtil.getAttribute((Element)xmlChild, (String)"name", (boolean)false);
                idString = XmlUtil.getAttribute((Element)xmlChild, (String)"id", (boolean)true);
                if (idString == null || idString.isEmpty() || (id = StringUtil.toLong((String)idString, (Long)-1L).longValue()) == -1L || (elementHandle = (ElementHandleImpl)element.giGetElement(childName)) == null) continue;
                elementHandle.setElementByIdInject(id, false);
            }
        }
        finally {
            if (document != null) {
                XmlUtil.destroy((Document)document);
            }
        }
        return element;
    }

    private IElement createElement(IElementType<?> type, IDomain domain) {
        Object element = domain.create(type);
        this.resource.putObject((IElement)element);
        return element;
    }
}

