/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.core.resource.DomainVersionConflict;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.Resource;
import net.edgemind.ibee.core.resource.UnsupportedVersionResourceException;
import net.edgemind.ibee.core.resource.reader.ParentCorrector;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlImfResourceReaderDom {
    private IProgressMonitor monitor;

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private void checkVersion(Document document) throws UnsupportedVersionResourceException {
        Element docElement = document.getDocumentElement();
        String modelVersion = "1.0";
        IDomain domain = null;
        String domainName = null;
        if (docElement != null) {
            modelVersion = XmlUtil.getAttribute((Element)docElement, (String)"version", (boolean)false, (String)"1.0");
            long rootId = StringUtil.toLong((String)docElement.getAttribute("root"), (Long)-1L);
            if (rootId != -1L) {
                List elements = XmlUtil.getChildrenByTagName((String)"element", (Element)docElement);
                for (Element xmlElement : elements) {
                    long id = StringUtil.toLong((String)xmlElement.getAttribute("id"), (Long)-1L);
                    if (id != rootId) continue;
                    domainName = xmlElement.getAttribute("domain");
                }
            }
        }
        if (domainName == null) {
            throw new IbeeException("Cannot retrieve domain from XML file");
        }
        domain = DomainRegistry.getDomain(domainName);
        if (domain == null) {
            throw new IbeeException("Unknown domain declartion " + domainName);
        }
        if (!domain.isCompatible(modelVersion)) {
            DomainVersionConflict conflict = new DomainVersionConflict();
            conflict.domainName = domainName;
            conflict.modelVersion = this.normVersion(modelVersion);
            conflict.domainVersion = this.normVersion(domain.getVersion());
            throw new UnsupportedVersionResourceException(conflict);
        }
    }

    private String normVersion(String version) {
        if (version == null || version.trim().equals("")) {
            return "1.0";
        }
        return version;
    }

    public Resource readModel(String path, Class clazz, IbeeResource resource) throws IOException {
        resource.reset();
        Document document = null;
        try {
            document = XmlUtil.readXmlFile((InputStream)clazz.getResourceAsStream(path));
            this.checkVersion(document);
            this.readModel(document.getDocumentElement(), resource);
        }
        finally {
            if (document != null) {
                XmlUtil.destroy((Document)document);
            }
        }
        return resource;
    }

    public Resource readModel(InputStream in, IbeeResource resource) throws IOException {
        resource.reset();
        Document document = null;
        try {
            document = XmlUtil.readXmlFile((InputStream)in);
            this.checkVersion(document);
            this.readModel(document.getDocumentElement(), resource);
        }
        finally {
            if (document != null) {
                XmlUtil.destroy((Document)document);
            }
        }
        return resource;
    }

    public Resource readModel(String filePath, IbeeResource resource) throws IOException {
        resource.reset();
        Document document = null;
        try {
            document = XmlUtil.readXmlFile((String)filePath);
            this.checkVersion(document);
            this.readModel(document.getDocumentElement(), resource);
        }
        finally {
            if (document != null) {
                XmlUtil.destroy((Document)document);
            }
        }
        return resource;
    }

    private void readModel(Element parent, IbeeResource resource) throws IOException {
        try {
            resource.disableNotifications();
            this.readLibraries(parent, resource);
            this.parseContent(parent, resource, null);
            long rootId = StringUtil.toLong((String)parent.getAttribute("root"), (Long)-1L);
            if (rootId != -1L) {
                resource.setRoot(resource.getObject(rootId));
            }
            resource.setDirty(false);
            ParentCorrector corrector = new ParentCorrector();
            corrector.correct(resource);
        }
        finally {
            resource.enableNotifications();
        }
    }

    private void readLibraries(Element parent, IbeeResource resource) {
        List xmlLibraries = XmlUtil.getChildrenByTagName((String)"library", (Element)parent);
        for (Element xmlLibrary : xmlLibraries) {
            IbeeLibrary lib = new IbeeLibrary();
            String name = xmlLibrary.getAttribute("name");
            String url = xmlLibrary.getAttribute("url");
            lib.setName(name);
            resource.addLibrary(lib, url, -1);
        }
    }

    private void parseContent(Element parentXml, IbeeResource resource, IElement parent) throws IOException {
        List elements = XmlUtil.getChildrenByTagName((String)"element", (Element)parentXml);
        this.startTask("Parsing Model...", elements.size());
        this.parseElements(parentXml, resource, parent);
        this.endTask();
    }

    private List<Long> parseElements(Element parentXml, IbeeResource resource, IElement parent) throws IOException {
        List elements = XmlUtil.getChildrenByTagName((String)"element", (Element)parentXml);
        ArrayList<Long> childids = new ArrayList<Long>();
        for (Element xmlElement : elements) {
            List<Long> ids;
            if (this.checkCancel()) {
                throw new IbeeException("Operation canceled.");
            }
            this.incProgress(1);
            IDomain domain = null;
            String domainName = xmlElement.getAttribute("domain");
            if ((domainName == null || domainName.equals("")) && parent != null) {
                domain = parent.giGetElementType().getDomain();
            } else {
                domain = DomainRegistry.getDomain(domainName);
                if (domain == null) {
                    LogUtil.error("ModelReader:parseElement:unknown domain '" + domainName + "'");
                    continue;
                }
            }
            String typeName = xmlElement.getAttribute("type");
            IElementType<?> type = domain.getType(typeName);
            if (type == null) {
                LogUtil.error("ModelReader:parseElement:unkown type '" + typeName + "'");
                continue;
            }
            Object element = domain.create(type);
            String idString = xmlElement.getAttribute("id");
            if (idString != null && !idString.isEmpty()) {
                long id = StringUtil.toLong((String)idString, (Long)-1L);
                ((AElementImpl)element).giSetId(id);
                childids.add(id);
            }
            resource.putObject((IElement)element);
            List xmlAttributes = XmlUtil.getChildrenByTagName((String)"attribute", (Element)xmlElement);
            for (Element xmlAttribute : xmlAttributes) {
                element.giSetAttribute(xmlAttribute.getAttribute("name"), xmlAttribute.getTextContent());
            }
            List xmlLists = XmlUtil.getChildrenByTagName((String)"list", (Element)xmlElement);
            for (Element xmlList : xmlLists) {
                ListHandleImpl listHandle;
                String listName = XmlUtil.getAttribute((Element)xmlList, (String)"name", (boolean)false);
                String idSequence = XmlUtil.getAttribute((Element)xmlList, (String)"ids", (boolean)true);
                if (idSequence != null && !idSequence.isEmpty() && (listHandle = (ListHandleImpl)element.giGetList(listName)) != null) {
                    String[] args;
                    ArrayList<Long> ids2 = new ArrayList<Long>();
                    String[] stringArray = args = idSequence.split(",");
                    int n = args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String arg = stringArray[n2];
                        long id = StringUtil.toLong((String)arg, (Long)-1L);
                        if (id != -1L) {
                            ids2.add(id);
                        }
                        ++n2;
                    }
                    listHandle.setAllElementsByIdInject(ids2, false);
                }
                if ((ids = this.parseElements(xmlList, resource, (IElement)element)) == null || ids.size() <= 0) continue;
                ListHandleImpl listHandle2 = (ListHandleImpl)element.giGetList(listName);
                listHandle2.setAllElementsByIdInject(ids, false);
            }
            List xmlChilds = XmlUtil.getChildrenByTagName((String)"element", (Element)xmlElement);
            for (Element xmlChild : xmlChilds) {
                ElementHandleImpl elementHandle;
                long id;
                String childName = XmlUtil.getAttribute((Element)xmlChild, (String)"name", (boolean)false);
                idString = XmlUtil.getAttribute((Element)xmlChild, (String)"id", (boolean)true);
                if (idString != null && !idString.isEmpty() && (id = StringUtil.toLong((String)idString, (Long)-1L).longValue()) != -1L && (elementHandle = (ElementHandleImpl)element.giGetElement(childName)) != null) {
                    elementHandle.setElementByIdInject(id, false);
                }
                if ((ids = this.parseElements(xmlChild, resource, (IElement)element)) == null || ids.size() <= 0) continue;
                ElementHandleImpl elementHandle2 = (ElementHandleImpl)element.giGetElement(childName);
                elementHandle2.setElementByIdInject(ids.get(0), false);
            }
        }
        return childids;
    }

    private boolean checkCancel() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    public void incProgress(int i) {
        if (this.monitor != null) {
            this.monitor.worked(i);
        }
    }

    public void startTask(String taskName, int totalWork) {
        if (this.monitor != null) {
            this.monitor.beginTask(taskName, totalWork);
        }
    }

    public void endTask() {
        if (this.monitor != null) {
            this.monitor.done();
        }
    }
}

