/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.UserData;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.LibraryDescriptor;
import net.edgemind.ibee.util.string.StringUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxHandler
extends DefaultHandler {
    private STATE state = STATE.NONE;
    private ArrayDeque<StackElement> objectStack = new ArrayDeque();
    private IbeeResource resource;
    private int objectCountTotal;
    private IProgressMonitor monitor;
    private IUserIO userIo;
    private ILogHandler logHandler;
    private int objectCount;
    private int lastProgress;
    private IbeeLibrary currenLibrary;
    String currentLibraryFeature;
    private boolean inconsistentContinueQuestionPosed = false;
    private IElement rootElement;

    public SaxHandler(IbeeResource resource) {
        this.resource = resource;
    }

    public void setNrOfObjects(int count) {
        this.objectCountTotal = count;
        this.objectCount = 0;
        this.lastProgress = 0;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setUserIo(IUserIO io) {
        this.userIo = io;
    }

    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.startElement(localName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.endElement(localName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length > 0) {
            String text = new String(ch, start, length);
            this.writeCharacters(text);
        }
    }

    @Override
    public void endDocument() {
    }

    private StackElement peek() {
        return this.objectStack.peekLast();
    }

    private StackElement pop() {
        return this.objectStack.pollLast();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String tag, Attributes attributes) throws SAXException {
        StackElement top;
        if (!this.objectStack.isEmpty() && (top = this.peek()) instanceof InvalidStackElement) {
            this.objectStack.add(new InvalidStackElement());
            return;
        }
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
            }
            if (this.monitor.isCanceled()) {
                throw new ManualInteruptionException("Reading procedure has been canceled");
            }
        }
        if (this.state == STATE.NONE) {
            if (!tag.equals("resource")) throw new SAXException("tag 'resource' expected");
            this.state = STATE.PARSE_RESOURCE;
        } else if (this.state == STATE.PARSE_RESOURCE) {
            if (!tag.equals("meta")) {
                if (tag.equals("root")) {
                    this.state = STATE.PARSE_ELEMENTS;
                } else if (tag.equals("libraries")) {
                    this.state = STATE.PARSE_LIB;
                }
            }
        } else if (this.state == STATE.PARSE_LIB) {
            if (tag.equals("library")) {
                this.currenLibrary = new IbeeLibrary();
            } else if (tag.equals("name")) {
                this.currentLibraryFeature = "name";
            } else if (tag.equals("url")) {
                this.currentLibraryFeature = "url";
            }
        }
        if (this.state != STATE.PARSE_ELEMENTS) return;
        if (this.objectStack.size() == 0) {
            this.rootElement = this.createElement(tag, attributes);
            if (this.rootElement == null) return;
            this.resource.setRoot(this.rootElement);
            this.objectStack.add(new StackElement(this.rootElement));
            return;
        } else {
            top = this.peek();
            IElement parent = top.element;
            boolean createChild = false;
            if (top.feature instanceof IListFeature && ((IListFeature)top.feature).isContainment()) {
                createChild = true;
            }
            if (top.feature == null) {
                createChild = false;
                IFeature feature = this.getFeatureByTagName(parent.giGetElementType(), tag);
                if (feature == null) {
                    String ename = top.element.giGetElementType().getName();
                    String msg = "Unexpected tag " + tag + " within element " + ename;
                    this.error(msg);
                    this.objectStack.add(new InvalidStackElement());
                    return;
                }
                top.feature = feature;
                if (feature instanceof IElementFeature && ((IElementFeature)top.feature).isContainment()) {
                    createChild = true;
                }
            }
            if (!createChild) return;
            IElement element = this.createElement(tag, attributes);
            if (element != null) {
                IFeature feature = top.feature;
                if (feature instanceof IListFeature) {
                    if (((IListFeature)feature).isContainment() && parent.giGetResource() != null) {
                        parent.giGetList((IListFeature)feature).addElement(element);
                    }
                } else if (feature instanceof IElementFeature && ((IElementFeature)feature).isContainment() && parent.giGetResource() != null) {
                    parent.giGetElement((IElementFeature)feature).setElement(element);
                }
                this.objectStack.add(new StackElement(element));
                return;
            } else {
                this.error("Cannot create Element " + tag);
                this.objectStack.add(new InvalidStackElement());
                return;
            }
        }
    }

    private IFeature getFeatureByTagName(IElementType<?> type, String tag) {
        IFeature f = type.getAttributeFeature(tag);
        if (f == null) {
            f = type.getElementFeature(tag);
        }
        if (f == null) {
            f = type.getListFeature(tag);
        }
        if (f == null) {
            f = this.getFeatureByCompatibleXmlName(type, tag);
        }
        return f;
    }

    private IFeature getFeatureByCompatibleXmlName(IElementType<?> type, String tag) {
        for (IFeature f : type.getAllFeatures()) {
            String compatibleName = f.getUserData().get("compatibleName");
            if (compatibleName == null || !compatibleName.equalsIgnoreCase(tag)) continue;
            return f;
        }
        return null;
    }

    private IElement createElement(String tag, Attributes attributes) throws SAXException {
        IElementType<?> type = this.getElementTypeToCreate(tag, attributes);
        if (type == null) {
            throw new SAXException("Cannot determine type from xml element '" + tag + "'");
        }
        Object element = type.getDomain().create(type);
        String id = this.getAttributeValue(tag, attributes, "id", true, "-1");
        ((AElementImpl)element).giSetId(StringUtil.toLong((String)id, (Long)-1L));
        this.resource.putObject((IElement)element);
        return element;
    }

    private IElementType<?> getElementTypeToCreate(String tag, Attributes attributes) throws SAXException {
        IElementType<?> type = null;
        if (this.objectStack.size() == 0) {
            String typeName = this.getAttributeValue(tag, attributes, "type", false, null);
            type = this.getElementTypeByName(typeName, this.getDomain(tag, attributes));
            if (type == null) {
                throw new SAXException(String.format("Xml element '%s': cannot determine element type for type '%s'", tag, typeName));
            }
        } else {
            StackElement top = this.peek();
            if (top.feature instanceof IElementFeature) {
                type = this.getElementTypeToCreateForElementFeature((IElementFeature)top.feature, tag, attributes);
            } else if (top.feature instanceof IListFeature) {
                type = this.getElementTypeToCreateForListFeature(tag, attributes);
            }
        }
        return type;
    }

    private IElementType<?> getElementTypeToCreateForElementFeature(IElementFeature<?> elementFeature, String tag, Attributes attributes) throws SAXException {
        IElementType<?> type = null;
        if (this.objectStack.size() > 0) {
            String typeName = this.getAttributeValue(tag, attributes, "type", false, null);
            if (typeName != null) {
                type = this.getElementTypeByName(typeName, this.getDomain(tag, attributes));
            } else if (elementFeature.getTypes().size() == 1) {
                type = elementFeature.getTypes().get(0);
            }
        }
        return type;
    }

    private IElementType<?> getElementTypeToCreateForListFeature(String tag, Attributes attributes) throws SAXException {
        String typeName = tag;
        return this.getElementTypeByName(typeName, this.getDomain(tag, attributes));
    }

    private IElementType<?> getElementTypeByName(String typeName, IDomain domain) {
        if (domain == null) {
            return null;
        }
        return domain.getType(typeName);
    }

    private IDomain getDomain(String tag, Attributes attributes) throws SAXException {
        IDomain domain = null;
        domain = this.getDomainFromExplicitAttribute(tag, attributes);
        if (domain == null) {
            domain = this.getDomainFromTopStackElement();
        }
        return domain;
    }

    private IDomain getDomainFromExplicitAttribute(String tag, Attributes attributes) throws SAXException {
        IDomain domain = null;
        String domainName = this.getAttributeValue(tag, attributes, "domain", false, null);
        if (domainName != null && (domain = DomainRegistry.getDomain(domainName)) == null) {
            throw new SAXException("Domain '" + domainName + "' not found");
        }
        return domain;
    }

    private IDomain getDomainFromTopStackElement() {
        if (this.objectStack.size() > 0) {
            StackElement top = this.peek();
            return top.element.giGetElementType().getDomain();
        }
        return null;
    }

    private String getAttributeValue(String tag, Attributes attributes, String attr, boolean required, String def) throws SAXException {
        int index = attributes.getIndex(attr);
        if (index >= 0) {
            return attributes.getValue(index);
        }
        if (required) {
            this.error("Missing attribute " + attr + " in element " + tag);
        }
        return def;
    }

    public void endElement(String tag) throws SAXException {
        StackElement top;
        if (!this.objectStack.isEmpty() && (top = this.peek()) instanceof InvalidStackElement) {
            this.pop();
            return;
        }
        if (this.state == STATE.PARSE_LIB) {
            if (tag.equals("libraries")) {
                this.state = STATE.PARSE_RESOURCE;
            }
        } else if (this.state == STATE.PARSE_ELEMENTS) {
            top = this.peek();
            if (top.feature != null) {
                top.feature = null;
            } else {
                this.pop();
                if (this.objectStack.size() > 0) {
                    top = this.peek();
                    if (top.feature instanceof IElementFeature && ((IElementFeature)top.feature).isContainment()) {
                        top.feature = null;
                    }
                }
                if (this.objectStack.size() == 0) {
                    if (tag.equals("root")) {
                        this.state = STATE.PARSE_RESOURCE;
                    } else {
                        throw new SAXException("Unexpected tag '" + tag + "'. Closing 'root' tag expected ");
                    }
                }
            }
        }
    }

    public void writeCharacters(String value) throws SAXException {
        StackElement top;
        if (!this.objectStack.isEmpty() && (top = this.peek()) instanceof InvalidStackElement) {
            return;
        }
        if (this.state == STATE.PARSE_LIB) {
            if (value == null || ((String)value).length() == 0) {
                return;
            }
            if (((String)value).trim().equals("")) {
                return;
            }
            if (this.currentLibraryFeature == null) {
                this.error("library definition broken [1]");
            } else if (this.currentLibraryFeature.equals("name")) {
                String pre = this.currenLibrary.getName();
                if (pre != null) {
                    this.currenLibrary.setName(pre + (String)value);
                } else {
                    this.currenLibrary.setName((String)value);
                }
            } else if (this.currentLibraryFeature.equals("url")) {
                String url = value;
                if (this.currenLibrary == null) {
                    this.error("library definition broken [2]");
                } else {
                    LibraryDescriptor libDesc = this.resource.getDescriptor(this.currenLibrary);
                    if (libDesc != null) {
                        libDesc.setUrl(libDesc.getUrl() + (String)value);
                    } else {
                        this.resource.addLibrary(this.currenLibrary, url, -1);
                    }
                }
            }
        } else if (this.state == STATE.PARSE_ELEMENTS) {
            if (value == null || ((String)value).length() == 0) {
                return;
            }
            if (((String)value).trim().equals("")) {
                return;
            }
            StackElement currentElement = this.peek();
            if (!(currentElement.feature instanceof InvalidFeature)) {
                if (currentElement.feature instanceof IAttributeFeature) {
                    String textPre = currentElement.element.giGetAttributeRaw((IAttributeFeature)currentElement.feature);
                    if (textPre != null) {
                        value = textPre + (String)value;
                    }
                    currentElement.element.giSetAttributeRaw((IAttributeFeature)currentElement.feature, (String)value);
                } else if (currentElement.feature instanceof IListFeature && !((IListFeature)currentElement.feature).isContainment()) {
                    String[] idlist;
                    ArrayList<Long> ids = new ArrayList<Long>();
                    String[] stringArray = idlist = ((String)value).split(",");
                    int n = idlist.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String next = stringArray[n2];
                        Long id = StringUtil.toLong((String)next, (Long)-1L);
                        if (id != -1L) {
                            ids.add(id);
                        }
                        ++n2;
                    }
                    IListHandle handle = currentElement.element.giGetList((IListFeature)currentElement.feature);
                    ((ListHandleImpl)handle).setAllElementsByIdInject(ids, false);
                } else if (currentElement.feature instanceof IElementFeature && !((IElementFeature)currentElement.feature).isContainment()) {
                    Long id = StringUtil.toLong((String)value, (Long)-1L);
                    if (id != -1L) {
                        IElementHandle handle = currentElement.element.giGetElement((IElementFeature)currentElement.feature);
                        ((ElementHandleImpl)handle).setElementByIdInject(id, false);
                    }
                } else {
                    String ename = currentElement.element.giGetElementType().getName();
                    String fname = currentElement.feature != null ? currentElement.feature.getName() : "???";
                    this.error("Unexpected character data " + (String)value + " for feature " + ename + ":" + fname);
                }
            }
        }
    }

    private void error(String msg) throws SAXException {
        if (!this.inconsistentContinueQuestionPosed) {
            if (this.userIo == null) {
                throw new SAXException(msg);
            }
            String question = msg + "\nDo you want to continue (resource may be incomplete or inconsistent)?";
            LinkedHashMap<Object, String> choices = new LinkedHashMap<Object, String>();
            choices.put(Boolean.FALSE, "No");
            choices.put(Boolean.TRUE, "Yes");
            Object answer = this.userIo.promptChoice("Problem occurred while reading resource", question, choices);
            if (answer != Boolean.TRUE) {
                throw new SAXException("Inconsistent Resource: Reading Failed");
            }
            this.inconsistentContinueQuestionPosed = true;
        }
        if (this.logHandler != null) {
            this.logHandler.log(msg, LogLevel.ERROR);
        }
    }

    static class InvalidFeature
    implements IFeature {
        InvalidFeature() {
        }

        @Override
        public String getName() {
            return "invalid";
        }

        public IElementType<? extends IElement> getElementType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isData() {
            return false;
        }

        @Override
        public UserData getUserData() {
            return null;
        }

        @Override
        public boolean isKey() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }
    }

    static class InvalidStackElement
    extends StackElement {
        public InvalidStackElement() {
            super(null);
        }
    }

    private static enum STATE {
        NONE,
        PARSE_RESOURCE,
        PARSE_LIB,
        PARSE_ELEMENTS;

    }

    static class StackElement {
        IElement element;
        IFeature feature;

        public StackElement(IElement el) {
            this.element = el;
        }
    }
}

