/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.reader.sax.StaxHandlerGeneric;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class SaxIbeeResourceReaderGeneric {
    private IProgressMonitor monitor;
    private ILogHandler logHandler;
    private IUserIO io;
    private IbeeResource model;
    private StaxHandlerGeneric handler;

    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public void readModel(String fileName, IbeeResource resource) throws IbeeException {
        this.readModel(fileName, resource, null);
    }

    public void readModel(String fileName, IbeeResource resource, IProgressMonitor monitor) throws IbeeException {
        this.model = null;
        this.monitor = monitor;
        this.model = resource;
        this.parse(fileName);
    }

    private void parse(String fileName) throws IbeeException {
        try {
            File file = new File(fileName);
            InputStream xmlInput = null;
            try {
                if (this.monitor != null) {
                    this.monitor.beginTask("Reading Model", 100);
                }
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
                this.handler = new StaxHandlerGeneric(this.model);
                this.handler.setMonitor(this.monitor);
                this.handler.setUserIo(this.io);
                this.handler.setLogHandler(this.logHandler);
                this.handler.setNrOfObjects(this.countObjects(file));
                xmlInput = this.createInputStream(file);
                XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(xmlInput, "UTF-8");
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlElement;
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (xmlEvent.isStartElement()) {
                        xmlElement = xmlEvent.asStartElement();
                        this.handler.startElement((StartElement)xmlElement);
                        continue;
                    }
                    if (xmlEvent.isEndElement()) {
                        xmlElement = xmlEvent.asEndElement();
                        this.handler.endElement((EndElement)xmlElement);
                        continue;
                    }
                    if (!xmlEvent.isCharacters()) continue;
                    Characters characters = xmlEvent.asCharacters();
                    this.handler.writeCharacters(characters);
                }
            }
            finally {
                if (xmlInput != null) {
                    xmlInput.close();
                }
                if (this.monitor != null) {
                    this.monitor.done();
                }
            }
        }
        catch (IbeeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IbeeException(e);
        }
        catch (Exception e) {
            throw new IbeeException(e);
        }
    }

    private int countObjects(File file) throws IbeeException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        InputStream xmlInput = null;
        int nr = 0;
        try {
            try {
                xmlInput = this.createInputStream(file);
                XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(xmlInput);
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (!xmlEvent.isStartElement()) continue;
                    ++nr;
                }
            }
            catch (XMLStreamException e) {
                throw new IbeeException(e);
            }
            catch (IOException e1) {
                throw new IbeeException(e1);
            }
        }
        finally {
            if (xmlInput != null) {
                try {
                    xmlInput.close();
                }
                catch (IOException e) {
                    throw new IbeeException(e);
                }
            }
        }
        return nr;
    }

    private InputStream createInputStream(File file) throws IOException {
        if (FileUtil.isZipFile((File)file)) {
            return FileUtil.openZippedInputStream((File)file, (String)"_model.xml");
        }
        return FileUtil.openInputStream((File)file);
    }
}

