/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.domain.UserData;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.iml.model.impl.AElementImpl;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.string.StringUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.SAXException;

public class StaxHandler {
    private STATE state = STATE.NONE;
    private Stack<StackElement> objectStack = new Stack();
    private IbeeResource resource;
    private int objectCountTotal;
    private IProgressMonitor monitor;
    private IUserIO userIo;
    private ILogHandler logHandler;
    private int objectCount;
    private int lastProgress;
    private IbeeLibrary currenLibrary;
    String currentLibraryFeature;
    private boolean inconsistentContinueQuestionPosed = false;

    public StaxHandler(IbeeResource model) {
        this.resource = model;
    }

    public void setNrOfObjects(int count) {
        this.objectCountTotal = count;
        this.objectCount = 0;
        this.lastProgress = 0;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void setUserIo(IUserIO io) {
        this.userIo = io;
    }

    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(StartElement xml) throws SAXException {
        StackElement top;
        if (!this.objectStack.isEmpty() && (top = this.objectStack.peek()) instanceof InvalidStackElement) {
            this.objectStack.add(new InvalidStackElement());
            return;
        }
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
            }
            if (this.monitor.isCanceled()) {
                throw new ManualInteruptionException("Reading procedure has been canceled");
            }
        }
        String tag = xml.getName().getLocalPart();
        if (this.state == STATE.NONE) {
            if (!tag.equals("resource")) throw new SAXException("tag 'resource' expected");
            this.state = STATE.PARSE_RESOURCE;
        } else if (this.state == STATE.PARSE_RESOURCE) {
            if (!tag.equals("meta")) {
                if (tag.equals("root")) {
                    this.state = STATE.PARSE_ELEMENTS;
                } else if (tag.equals("libraries")) {
                    this.state = STATE.PARSE_LIB;
                } else {
                    this.error("unexpected tag '" + tag + "' in line " + xml.getLocation().getLineNumber() + ":" + xml.getLocation().getCharacterOffset());
                }
            }
        } else if (this.state == STATE.PARSE_LIB) {
            if (tag.equals("library")) {
                this.currenLibrary = new IbeeLibrary();
            } else if (tag.equals("name")) {
                this.currentLibraryFeature = "name";
            } else if (tag.equals("url")) {
                this.currentLibraryFeature = "url";
            }
        }
        if (this.state != STATE.PARSE_ELEMENTS) return;
        if (this.objectStack.size() == 0) {
            IElement element = this.createElement(xml);
            if (element == null) return;
            this.resource.setRoot(element);
            this.objectStack.add(new StackElement(element));
            return;
        } else {
            StackElement top2 = this.objectStack.peek();
            IElement parent = top2.element;
            boolean createChild = false;
            if (top2.feature instanceof IListFeature && ((IListFeature)top2.feature).isContainment()) {
                createChild = true;
            }
            if (top2.feature == null) {
                createChild = false;
                IFeature feature = this.getFeatureByTagName(parent.giGetElementType(), tag);
                if (feature == null) {
                    String ename = top2.element.giGetElementType().getName();
                    String msg = "Unexpected tag " + tag + " within element " + ename;
                    this.error(msg);
                    this.objectStack.add(new InvalidStackElement());
                    return;
                }
                top2.feature = feature;
                if (feature instanceof IElementFeature && ((IElementFeature)top2.feature).isContainment()) {
                    createChild = true;
                }
            }
            if (!createChild) return;
            IElement element = this.createElement(xml);
            if (element != null) {
                IFeature feature = top2.feature;
                if (feature instanceof IListFeature) {
                    if (((IListFeature)feature).isContainment() && parent.giGetResource() != null) {
                        parent.giGetList((IListFeature)feature).addElement(element);
                    }
                } else if (feature instanceof IElementFeature && ((IElementFeature)feature).isContainment() && parent.giGetResource() != null) {
                    parent.giGetElement((IElementFeature)feature).setElement(element);
                }
                this.objectStack.add(new StackElement(element));
                return;
            } else {
                this.error("Cannot create Element " + tag);
                this.objectStack.add(new InvalidStackElement());
                return;
            }
        }
    }

    private IFeature getFeatureByTagName(IElementType<?> type, String tag) {
        IFeature f = type.getAttributeFeature(tag);
        if (f == null) {
            f = type.getElementFeature(tag);
        }
        if (f == null) {
            f = type.getListFeature(tag);
        }
        if (f == null) {
            f = this.getFeatureByCompatibleXmlName(type, tag);
        }
        return f;
    }

    private IFeature getFeatureByCompatibleXmlName(IElementType<?> type, String tag) {
        for (IFeature f : type.getAllFeatures()) {
            String compatibleName = f.getUserData().get("compatibleName");
            if (compatibleName == null || !compatibleName.equalsIgnoreCase(tag)) continue;
            return f;
        }
        return null;
    }

    private IElement createElement(StartElement el) throws SAXException {
        IElementType<?> type = this.getElementTypeToCreate(el);
        if (type == null) {
            throw new SAXException("Cannot determine type from xml element '" + el.getName().getLocalPart() + "'");
        }
        Object element = type.getDomain().create(type);
        String id = this.getAttributeValue(el, "id", true, "-1");
        ((AElementImpl)element).giSetId(StringUtil.toLong((String)id, (Long)-1L));
        this.resource.putObject((IElement)element);
        return element;
    }

    private IElementType<?> getElementTypeToCreate(StartElement el) throws SAXException {
        IElementType<?> type = null;
        this.getDomain(el);
        if (this.objectStack.size() == 0) {
            String typeName = this.getAttributeValue(el, "type", false, null);
            type = this.getElementTypeByName(typeName, this.getDomain(el));
            if (type == null) {
                throw new SAXException(String.format("Xml element '%s': cannot determine element type for type '%s'", el.getName().getLocalPart(), typeName));
            }
        } else {
            StackElement top = this.objectStack.peek();
            if (top.feature instanceof IElementFeature) {
                type = this.getElementTypeToCreateForElementFeature((IElementFeature)top.feature, el);
            } else if (top.feature instanceof IListFeature) {
                type = this.getElementTypeToCreateForListFeature(el);
            }
        }
        return type;
    }

    private IElementType<?> getElementTypeToCreateForElementFeature(IElementFeature<?> elementFeature, StartElement el) throws SAXException {
        IElementType<?> type = null;
        if (this.objectStack.size() > 0) {
            String typeName = this.getAttributeValue(el, "type", false, null);
            if (typeName != null) {
                type = this.getElementTypeByName(typeName, this.getDomain(el));
            } else if (elementFeature.getTypes().size() == 1) {
                type = elementFeature.getTypes().get(0);
            }
        }
        return type;
    }

    private IElementType<?> getElementTypeToCreateForListFeature(StartElement el) throws SAXException {
        String typeName = el.getName().getLocalPart();
        return this.getElementTypeByName(typeName, this.getDomain(el));
    }

    private IElementType<?> getElementTypeByName(String typeName, IDomain domain) {
        if (domain == null) {
            return null;
        }
        return domain.getType(typeName);
    }

    private IDomain getDomain(StartElement el) throws SAXException {
        IDomain domain = null;
        domain = this.getDomainFromExplicitAttribute(el);
        if (domain == null) {
            domain = this.getDomainFromTopStackElement();
        }
        return domain;
    }

    private IDomain getDomainFromExplicitAttribute(StartElement el) throws SAXException {
        IDomain domain = null;
        String domainName = this.getAttributeValue(el, "domain", false, null);
        if (domainName != null && (domain = DomainRegistry.getDomain(domainName)) == null) {
            throw new SAXException("Domain '" + domainName + "' not found");
        }
        return domain;
    }

    private IDomain getDomainFromTopStackElement() {
        if (this.objectStack.size() > 0) {
            StackElement top = this.objectStack.peek();
            return top.element.giGetElementType().getDomain();
        }
        return null;
    }

    private String getAttributeValue(StartElement el, String attr, boolean required, String def) throws SAXException {
        Attribute xmlAttr = el.getAttributeByName(new QName(attr));
        if (xmlAttr != null) {
            return xmlAttr.getValue();
        }
        if (required) {
            this.error("Missing attribute " + attr + " in element " + el.getName().getLocalPart());
        }
        return def;
    }

    public void endElement(EndElement xml) throws SAXException {
        StackElement top;
        if (!this.objectStack.isEmpty() && (top = this.objectStack.peek()) instanceof InvalidStackElement) {
            this.objectStack.pop();
            return;
        }
        String tag = xml.getName().getLocalPart();
        if (this.state == STATE.PARSE_LIB) {
            if (tag.equals("libraries")) {
                this.state = STATE.PARSE_RESOURCE;
            }
        } else if (this.state == STATE.PARSE_ELEMENTS) {
            StackElement top2 = (StackElement)this.objectStack.get(this.objectStack.size() - 1);
            if (top2.feature != null) {
                top2.feature = null;
            } else {
                this.objectStack.pop();
                if (this.objectStack.size() > 0) {
                    top2 = (StackElement)this.objectStack.get(this.objectStack.size() - 1);
                    if (top2.feature instanceof IElementFeature && ((IElementFeature)top2.feature).isContainment()) {
                        top2.feature = null;
                    }
                }
                if (this.objectStack.size() == 0) {
                    if (tag.equals("root")) {
                        this.state = STATE.PARSE_RESOURCE;
                    } else {
                        throw new SAXException("Unexpected tag '" + tag + "'. Closing 'root' tag expected ");
                    }
                }
            }
        }
    }

    public void writeCharacters(Characters characters) throws SAXException {
        StackElement top;
        if (!this.objectStack.isEmpty() && (top = this.objectStack.peek()) instanceof InvalidStackElement) {
            return;
        }
        if (this.state == STATE.PARSE_LIB) {
            value = characters.getData();
            if (value == null || ((String)value).length() == 0) {
                return;
            }
            if (((String)value).trim().equals("")) {
                return;
            }
            if (this.currentLibraryFeature == null) {
                this.error("library definition broken [1]");
            } else if (this.currentLibraryFeature.equals("name")) {
                this.currenLibrary.setName((String)value);
            } else if (this.currentLibraryFeature.equals("url")) {
                String url = value;
                if (this.currenLibrary == null) {
                    this.error("library definition broken [2]");
                } else {
                    this.resource.addLibrary(this.currenLibrary, url, -1);
                }
            }
        } else if (this.state == STATE.PARSE_ELEMENTS) {
            value = characters.getData();
            if (value == null || ((String)value).length() == 0) {
                return;
            }
            if (((String)value).trim().equals("")) {
                return;
            }
            StackElement currentElement = this.objectStack.peek();
            if (!(currentElement.feature instanceof InvalidFeature)) {
                if (currentElement.feature instanceof IAttributeFeature) {
                    String textPre = currentElement.element.giGetAttributeRaw((IAttributeFeature)currentElement.feature);
                    if (textPre != null) {
                        value = textPre + (String)value;
                    }
                    currentElement.element.giSetAttribute((IAttributeFeature)currentElement.feature, (String)value);
                } else if (currentElement.feature instanceof IListFeature && !((IListFeature)currentElement.feature).isContainment()) {
                    String[] idlist;
                    ArrayList<Long> ids = new ArrayList<Long>();
                    String[] stringArray = idlist = ((String)value).split(",");
                    int n = idlist.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String next = stringArray[n2];
                        Long id = StringUtil.toLong((String)next, (Long)-1L);
                        if (id != -1L) {
                            ids.add(id);
                        }
                        ++n2;
                    }
                    IListHandle handle = currentElement.element.giGetList((IListFeature)currentElement.feature);
                    ((ListHandleImpl)handle).setAllElementsByIdInject(ids, false);
                } else if (currentElement.feature instanceof IElementFeature && !((IElementFeature)currentElement.feature).isContainment()) {
                    Long id = StringUtil.toLong((String)value, (Long)-1L);
                    if (id != -1L) {
                        IElementHandle handle = currentElement.element.giGetElement((IElementFeature)currentElement.feature);
                        ((ElementHandleImpl)handle).setElementByIdInject(id, false);
                    }
                } else {
                    String ename = currentElement.element.giGetElementType().getName();
                    String fname = currentElement.feature != null ? currentElement.feature.getName() : "???";
                    this.error("Unexpected character data " + (String)value + " for feature " + ename + ":" + fname);
                }
            }
        }
    }

    private void error(String msg) throws SAXException {
        if (!this.inconsistentContinueQuestionPosed) {
            if (this.userIo == null) {
                throw new SAXException(msg);
            }
            String question = msg + "\nDo you want to continue (resource may be incomplete or inconsistent)?";
            LinkedHashMap<Object, String> choices = new LinkedHashMap<Object, String>();
            choices.put(Boolean.FALSE, "No");
            choices.put(Boolean.TRUE, "Yes");
            Object answer = this.userIo.promptChoice("Problem occurred while reading resource", question, choices);
            if (answer != Boolean.TRUE) {
                throw new SAXException("Inconsistent Resource: Reading Failed");
            }
            this.inconsistentContinueQuestionPosed = true;
        }
        if (this.logHandler != null) {
            this.logHandler.log(msg, LogLevel.ERROR);
        }
    }

    static class InvalidFeature
    implements IFeature {
        InvalidFeature() {
        }

        @Override
        public String getName() {
            return "invalid";
        }

        public IElementType<? extends IElement> getElementType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isData() {
            return false;
        }

        @Override
        public UserData getUserData() {
            return null;
        }

        @Override
        public boolean isKey() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public boolean isDeprecated() {
            return false;
        }
    }

    static class InvalidStackElement
    extends StackElement {
        public InvalidStackElement() {
            super(null);
        }
    }

    private static enum STATE {
        NONE,
        PARSE_RESOURCE,
        PARSE_LIB,
        PARSE_ELEMENTS;

    }

    static class StackElement {
        IElement element;
        IFeature feature;

        public StackElement(IElement el) {
            this.element = el;
        }
    }
}

