/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogableAndMonitored;
import net.edgemind.ibee.core.resource.DomainVersionConflict;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.UnsupportedVersionResourceException;
import net.edgemind.ibee.core.resource.reader.XmlReaderException;
import net.edgemind.ibee.core.resource.reader.sax.ImfVersionReader;
import net.edgemind.ibee.core.resource.reader.sax.SaxHandler;
import net.edgemind.ibee.core.resource.reader.sax.StaxHandler;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlImfResourceReaderSax
extends LogableAndMonitored {
    private IProgressMonitor monitor;
    private IUserIO userIo;
    private ILogHandler logHandler;
    private IbeeResource model;
    private boolean checkVersion = true;

    public boolean getCheckVersion() {
        return this.checkVersion;
    }

    public void setCheckVersion(boolean checkVersion) {
        this.checkVersion = checkVersion;
    }

    public void setIO(IUserIO userIo) {
        this.userIo = userIo;
    }

    @Override
    public void setLogHandler(ILogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public void readModel(File file, IbeeResource resource) throws IOException {
        this.readModel(file, resource, null);
    }

    public void readModel(File file, IbeeResource resource, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_7 = null;
        try (InputStream stream = this.createResetableStream(file);){
            this.readModelFromResetableStream(stream, resource, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void readModel(InputStream in, IbeeResource resource) throws IOException {
        this.readModel(in, resource, null);
    }

    public void readModel(InputStream in, IbeeResource resource, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var5_7 = null;
        try (InputStream stream = this.createResetableStream(in);){
            this.readModelFromResetableStream(stream, resource, monitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void readModelFromResetableStream(InputStream in, IbeeResource resource, IProgressMonitor monitor) throws IOException {
        this.monitor = monitor;
        this.model = resource;
        if (this.checkVersion) {
            Map<String, String> meta = this.getMetaDataOfModel(in);
            in.reset();
            String version = meta.get("domain-version");
            String domainName = meta.get("domain-name");
            if (version == null) {
                version = "1.0";
            }
            this.checkVersion(version, domainName);
        }
        try {
            resource.disableNotifications();
            this.parseSax(in);
        }
        finally {
            resource.enableNotifications();
        }
        resource.setDirty(false);
    }

    private InputStream createResetableStream(File file) throws IOException {
        return FileUtil.ensureResetableZippedStream((File)file, (String)"_model.xml");
    }

    private InputStream createResetableStream(InputStream stream) throws IOException {
        return FileUtil.ensureResetableZippedStream((InputStream)stream, (String)"_model.xml");
    }

    private void checkVersion(String modelVersion, String domainName) throws UnsupportedVersionResourceException {
        IDomain domain;
        if (modelVersion == null) {
            modelVersion = "1.0";
        }
        if ((domain = DomainRegistry.getDomain(domainName)) == null) {
            throw new ResourceException(String.format("Unknown domain '%s'", domainName));
        }
        if (!domain.isCompatible(modelVersion)) {
            DomainVersionConflict conflict = new DomainVersionConflict();
            conflict.modelVersion = modelVersion;
            conflict.domainVersion = domain.getVersion();
            conflict.domainName = domainName;
            throw new UnsupportedVersionResourceException(conflict);
        }
    }

    private void parseSax(InputStream stream) throws IbeeException {
        if (this.monitor != null) {
            this.monitor.beginTask("Reading Model", 100);
        }
        try {
            try {
                InputSource inputSource = new InputSource(stream);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                SAXParser saxParser = factory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                int cntObjects = this.countObjects(stream);
                stream.reset();
                SaxHandler handler = new SaxHandler(this.model);
                handler.setNrOfObjects(cntObjects);
                handler.setMonitor(this.monitor);
                handler.setLogHandler(this.logHandler);
                handler.setUserIo(this.userIo);
                xmlReader.setContentHandler(handler);
                xmlReader.parse(inputSource);
            }
            catch (SAXNotRecognizedException e) {
                throw new IbeeException(e);
            }
            catch (SAXNotSupportedException e) {
                throw new IbeeException(e);
            }
            catch (SAXException e) {
                throw new IbeeException(e);
            }
            catch (IOException e) {
                throw new IbeeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new IbeeException(e);
            }
            catch (XMLStreamException e) {
                throw new IbeeException(e);
            }
        }
        finally {
            if (this.monitor != null) {
                this.monitor.done();
            }
        }
    }

    private void parseStax(InputStream stream) throws IbeeException {
        try {
            XMLEventReader xmlEventReader = null;
            try {
                if (this.monitor != null) {
                    this.monitor.beginTask("Reading Model", 100);
                }
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
                xmlInputFactory.setProperty("javax.xml.stream.isValidating", false);
                xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
                xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
                StaxHandler handler = new StaxHandler(this.model);
                handler.setMonitor(this.monitor);
                handler.setLogHandler(this.logHandler);
                handler.setUserIo(this.userIo);
                int cntObjects = this.countObjects(stream);
                handler.setNrOfObjects(cntObjects);
                stream.reset();
                xmlEventReader = xmlInputFactory.createXMLEventReader(stream, "UTF-8");
                while (xmlEventReader.hasNext()) {
                    XMLEvent xmlElement;
                    this.interruptIfCancelled();
                    XMLEvent xmlEvent = xmlEventReader.nextEvent();
                    if (xmlEvent.isStartElement()) {
                        xmlElement = xmlEvent.asStartElement();
                        handler.startElement((StartElement)xmlElement);
                        continue;
                    }
                    if (xmlEvent.isEndElement()) {
                        xmlElement = xmlEvent.asEndElement();
                        handler.endElement((EndElement)xmlElement);
                        continue;
                    }
                    if (!xmlEvent.isCharacters()) continue;
                    Characters characters = xmlEvent.asCharacters();
                    handler.writeCharacters(characters);
                }
            }
            finally {
                if (this.monitor != null) {
                    this.monitor.done();
                }
            }
        }
        catch (IbeeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IbeeException(e);
        }
        catch (Exception e) {
            throw new IbeeException(e);
        }
    }

    private int countObjects(InputStream stream) throws IbeeException, XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = null;
        int nr = 0;
        try {
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(stream);
            while (xmlStreamReader.hasNext()) {
                this.interruptIfCancelled();
                int eventType = xmlStreamReader.next();
                if (eventType != 1) continue;
                ++nr;
            }
        }
        catch (XMLStreamException e) {
            throw new IbeeException(e);
        }
        return nr;
    }

    private Map<String, String> getMetaDataOfModel(InputStream stream) throws XmlReaderException {
        ImfVersionReader reader = new ImfVersionReader();
        return reader.getMetaData(stream);
    }
}

