/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.reader.sax2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.DomainRegistry;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.io.IUserIO;
import net.edgemind.ibee.core.log.LogableAndMonitored;
import net.edgemind.ibee.core.resource.DomainVersionConflict;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.ResourceException;
import net.edgemind.ibee.core.resource.UnsupportedVersionResourceException;
import net.edgemind.ibee.core.resource.reader.XmlReaderException;
import net.edgemind.ibee.core.resource.reader.sax2.ImfVersionReader2;
import net.edgemind.ibee.core.resource.reader.sax2.SaxHandler2;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class XmlImfResourceReaderSax2
extends LogableAndMonitored {
    private IUserIO userIo;
    private IbeeResource model;
    private boolean checkVersion = true;

    public boolean getCheckVersion() {
        return this.checkVersion;
    }

    public void setCheckVersion(boolean checkVersion) {
        this.checkVersion = checkVersion;
    }

    public IUserIO getUserIo() {
        return this.userIo;
    }

    public void setUserIo(IUserIO userIo) {
        this.userIo = userIo;
    }

    public void readModel(File file, IbeeResource resource) throws IOException {
        Throwable throwable = null;
        Object var4_6 = null;
        try (InputStream stream = this.createResetableStream(file);){
            this.readModelFromResetableStream(stream, resource);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void readModel(InputStream in, IbeeResource resource) throws IOException {
        Throwable throwable = null;
        Object var4_6 = null;
        try (InputStream stream = this.createResetableStream(in);){
            this.readModelFromResetableStream(stream, resource);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void readModelFromResetableStream(InputStream in, IbeeResource resource) throws IOException {
        this.model = resource;
        if (this.checkVersion) {
            Map<String, String> meta = this.getMetaDataOfModel(in);
            in.reset();
            String version = meta.get("domain-version");
            String domainName = meta.get("domain-name");
            if (version == null) {
                version = "1.0";
            }
            this.checkVersion(version, domainName);
        }
        try {
            resource.disableNotifications();
            this.parseSax2(in);
        }
        finally {
            resource.enableNotifications();
        }
        resource.setDirty(false);
    }

    private InputStream createResetableStream(File file) throws IOException {
        return FileUtil.ensureResetableZippedStream((File)file, (String)"_model.xml");
    }

    private InputStream createResetableStream(InputStream stream) throws IOException {
        return FileUtil.ensureResetableZippedStream((InputStream)stream, (String)"_model.xml");
    }

    private void checkVersion(String modelVersion, String domainName) throws UnsupportedVersionResourceException {
        IDomain domain;
        if (modelVersion == null) {
            modelVersion = "1.0";
        }
        if ((domain = DomainRegistry.getDomain(domainName)) == null) {
            throw new ResourceException(String.format("Unknown domain '%s'", domainName));
        }
        if (!domain.isCompatible(modelVersion)) {
            DomainVersionConflict conflict = new DomainVersionConflict();
            conflict.modelVersion = modelVersion;
            conflict.domainVersion = domain.getVersion();
            conflict.domainName = domainName;
            throw new UnsupportedVersionResourceException(conflict);
        }
    }

    private void parseSax2(InputStream stream) throws IbeeException {
        this.beginWork("Reading Model", 100);
        try {
            try {
                InputSource inputSource = new InputSource(stream);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                SAXParser saxParser = factory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                SaxHandler2 handler = new SaxHandler2(this.model);
                IProgressMonitor monitor = this.getMonitor();
                if (monitor != null && !(monitor instanceof NullProgressMonitor)) {
                    int cntObjects = this.countObjects(stream);
                    stream.reset();
                    handler.setNrOfObjects(cntObjects);
                    handler.setMonitor(monitor);
                }
                handler.setLogHandler(this.getLogHandler());
                handler.setUserIo(this.userIo);
                xmlReader.setContentHandler(handler);
                xmlReader.parse(inputSource);
            }
            catch (SAXNotRecognizedException e) {
                throw new IbeeException(e);
            }
            catch (SAXNotSupportedException e) {
                throw new IbeeException(e);
            }
            catch (SAXException e) {
                throw new IbeeException(e);
            }
            catch (IOException e) {
                throw new IbeeException(e);
            }
            catch (ParserConfigurationException e) {
                throw new IbeeException(e);
            }
            catch (XMLStreamException e) {
                throw new IbeeException(e);
            }
        }
        finally {
            this.done();
        }
    }

    private int countObjects(InputStream stream) throws IbeeException, XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlStreamReader = null;
        int nr = 0;
        try {
            xmlStreamReader = xmlInputFactory.createXMLStreamReader(stream);
            while (xmlStreamReader.hasNext()) {
                this.interruptIfCancelled();
                int eventType = xmlStreamReader.next();
                if (eventType != 1) continue;
                ++nr;
            }
        }
        catch (XMLStreamException e) {
            throw new IbeeException(e);
        }
        return nr;
    }

    private Map<String, String> getMetaDataOfModel(InputStream stream) throws XmlReaderException {
        ImfVersionReader2 reader = new ImfVersionReader2();
        return reader.getMetaData(stream);
    }
}

