/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.url;

import java.io.Serializable;
import net.edgemind.ibee.core.resource.url.Uri;

public class URL
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String scheme = "";
    protected String specificPart;
    protected String sid = "";
    protected String path = "";

    public URL(String urlString) {
        int index = urlString.indexOf(":");
        if (index >= 0) {
            this.scheme = urlString.substring(0, index);
            urlString = urlString.substring(index + 1);
        }
        if ((index = urlString.indexOf("//")) >= 0) {
            this.specificPart = urlString.substring(0, index);
            urlString = urlString.substring(index + 2);
        }
        if ((index = urlString.indexOf("/")) >= 0) {
            this.sid = urlString.substring(0, index);
            urlString = urlString.substring(index + 1);
        }
        this.path = urlString;
    }

    public URL setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setSpecificPart(String specificPart) {
        this.specificPart = specificPart;
    }

    public String getSpecificPart() {
        return this.specificPart;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public URL() {
    }

    public String getUrlString() {
        return this.toString();
    }

    public String toString() {
        return this.scheme + ":" + this.specificPart + "//" + this.sid + "/" + this.path;
    }

    public boolean equals(Object url) {
        if (url == null || !(url instanceof URL)) {
            return false;
        }
        return this.toString().equals(((URL)url).toString());
    }

    public URL getParent() {
        String path = this.getPath();
        if (path == null || path.isEmpty()) {
            return null;
        }
        int index = path.lastIndexOf("/");
        if (index < 0) {
            return null;
        }
        URL result = this.cloneUrl();
        result.setPath(path.substring(0, index));
        return result;
    }

    public String getUriPart() {
        return this.sid + "/" + this.path;
    }

    public String getSchemePart() {
        return this.scheme + ":" + this.specificPart;
    }

    public Uri getUri() {
        return new Uri(this.sid, this.path);
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public boolean isAbsolute() {
        return this.path.startsWith("/");
    }

    public boolean isValid() {
        return this.scheme != null && this.path != null && !this.scheme.isEmpty() && !this.specificPart.isEmpty();
    }

    public static URL createUrl(String urlString, URL parent) {
        URL url = new URL(urlString);
        if (url.isRelative()) {
            url.setPath(parent.getPath() + "/" + url.getPath());
        }
        if (url.getScheme().isEmpty()) {
            url.setScheme(parent.getScheme());
        }
        if (url.getSpecificPart().isEmpty()) {
            url.setSpecificPart(parent.getSpecificPart());
        }
        if (url.getSid().isEmpty()) {
            url.setSid(parent.sid);
        }
        return url;
    }

    public URL cloneUrl() {
        URL clone = new URL();
        clone.setScheme(this.getScheme());
        clone.setSpecificPart(this.getSpecificPart());
        clone.setSid(this.getSid());
        clone.setPath(this.getPath());
        return clone;
    }

    public boolean equals(URL url) {
        return this.toString().equals(url.toString());
    }

    public URL append(String path) {
        if (path.length() == 0) {
            return this;
        }
        if (this.path.length() > 0 && !path.startsWith("/") && !this.path.endsWith("/")) {
            this.path = String.valueOf(this.path) + "/";
        }
        this.path = String.valueOf(this.path) + path;
        return this;
    }

    public boolean isParentOf(URL child) {
        String s1 = this.toString();
        String s2 = child.toString();
        while (s1.endsWith("/")) {
            s1 = s1.substring(0, s1.length() - 1);
        }
        boolean condition1 = s2.startsWith(s1);
        if (!condition1) {
            return false;
        }
        int nextCharacter = 47;
        if (s2.length() > s1.length()) {
            nextCharacter = s2.charAt(s1.length());
        }
        return nextCharacter == 47;
    }
}

