/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IContent;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.LibraryDescriptor;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlLocalResourceWriter {
    boolean flat = false;

    public void write(IbeeResource resource, OutputStream out, long lastSyncId) throws IOException {
        Document doc = XmlUtil.createNewDocument();
        this.write(resource, lastSyncId, doc);
        XmlUtil.writeXmlFile((Document)doc, (OutputStream)out);
        resource.setDirty(false);
    }

    public void write(IbeeResource resource, File file, long lastSyncId) throws IOException {
        this.write(resource, file.getAbsolutePath(), lastSyncId);
    }

    public void write(IbeeResource resource, File file) throws IOException {
        this.write(resource, file.getAbsolutePath(), -1L);
    }

    public void write(IbeeResource resource, String filePath, long lastSyncId) throws IOException {
        Document doc = XmlUtil.createNewDocument();
        this.write(resource, lastSyncId, doc);
        XmlUtil.writeXmlFile((Document)doc, (String)filePath);
        resource.setDirty(false);
    }

    public void write(IbeeResource resource, long lastSyncId, Object parent) throws IOException {
        Element modelXml;
        if (parent instanceof Document) {
            modelXml = ((Document)parent).createElement("model");
            ((Document)parent).appendChild(modelXml);
        } else {
            modelXml = ((Element)parent).getOwnerDocument().createElement("model");
            ((Element)parent).appendChild(modelXml);
        }
        if (resource.getURL() != null) {
            modelXml.setAttribute("url", resource.getURL().toString());
        }
        this.writeLibraries(resource, modelXml);
        this.write(resource, lastSyncId, modelXml);
    }

    private void writeLibraries(IbeeResource resource, Element parentXml) throws IOException {
        for (IbeeLibrary library : resource.getLibraries()) {
            Element libraryXml = parentXml.getOwnerDocument().createElement("library");
            parentXml.appendChild(libraryXml);
            libraryXml.setAttribute("name", library.getName());
            LibraryDescriptor desc = resource.getDescriptor(library);
            libraryXml.setAttribute("url", desc.getUrl());
        }
    }

    private void write(IbeeResource resource, long lastSyncId, Element parent) throws IOException {
        IElement root = resource.getRoot();
        this.flat = true;
        if (this.flat) {
            Collection<IElement> objectsToWrite = resource.getAllObjects(lastSyncId);
            for (IElement element : objectsToWrite) {
                this.writeXml(element, parent);
            }
        } else {
            this.writeXml(root, parent);
        }
        if (root != null) {
            parent.setAttribute("root", "" + root.giGetElementId());
            String version = root.giGetElementType().getDomain().getVersion();
            if (version != null) {
                parent.setAttribute("version", version);
            }
        }
    }

    private void writeXml(IElement element, Element parentXml) throws IOException {
        IContent handle;
        long l;
        Element childXml = parentXml.getOwnerDocument().createElement("element");
        parentXml.appendChild(childXml);
        XmlUtil.setAttribute((Element)childXml, (String)"type", (String)element.giGetElementType().getName(), (boolean)false);
        IElement parent = element.giGetParent();
        if (this.flat || parent == null || element.giGetElementType().getDomain() != parent.giGetElementType().getDomain()) {
            XmlUtil.setAttribute((Element)childXml, (String)"domain", (String)element.giGetElementType().getDomain().getName(), (boolean)false);
        }
        XmlUtil.setAttribute((Element)childXml, (String)"id", (String)("" + element.giGetElementId()), (boolean)false);
        if (this.flat && parent != null && (l = element.giGetParent().giGetElementId()) != -1L) {
            XmlUtil.setAttribute((Element)childXml, (String)"parent", (String)("" + l), (boolean)true);
        }
        for (IElementFeature<IElement> iElementFeature : element.giGetElementType().getElementFeatures()) {
            Element featureElement;
            handle = (ElementHandleImpl)element.giGetElement(iElementFeature);
            long elementId = ((ElementHandleImpl)handle).getElementId();
            if (elementId == -1L) continue;
            if (this.flat || !iElementFeature.isContainment()) {
                featureElement = parentXml.getOwnerDocument().createElement("element");
                childXml.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iElementFeature.getName(), (boolean)false);
                XmlUtil.setAttribute((Element)featureElement, (String)"id", (String)("" + elementId), (boolean)true);
                continue;
            }
            featureElement = parentXml.getOwnerDocument().createElement("element");
            childXml.appendChild(featureElement);
            XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iElementFeature.getName(), (boolean)false);
            IElement resolved = element.giGetElement(iElementFeature).getElement();
            if (resolved == null) continue;
            this.writeXml(resolved, featureElement);
        }
        for (IListFeature iListFeature : element.giGetElementType().getListFeatures()) {
            Element featureElement;
            handle = (ListHandleImpl)element.giGetList(iListFeature);
            List<Long> ids = ((ListHandleImpl)handle).getAllElementIds();
            if (ids == null || ids.size() <= 0) continue;
            if (this.flat || !iListFeature.isContainment()) {
                featureElement = parentXml.getOwnerDocument().createElement("list");
                childXml.appendChild(featureElement);
                XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iListFeature.getName(), (boolean)false);
                StringBuilder idsBuf = new StringBuilder();
                for (long id : ids) {
                    if (idsBuf.length() > 0) {
                        idsBuf.append(",");
                    }
                    idsBuf.append(id);
                }
                XmlUtil.setAttribute((Element)featureElement, (String)"ids", (String)idsBuf.toString(), (boolean)true);
                continue;
            }
            featureElement = parentXml.getOwnerDocument().createElement("list");
            childXml.appendChild(featureElement);
            XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iListFeature.getName(), (boolean)false);
            for (IElement resolved : element.giGetList(iListFeature).getElements()) {
                if (resolved == null) continue;
                this.writeXml(resolved, featureElement);
            }
        }
        for (IAttributeFeature iAttributeFeature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(iAttributeFeature, null);
            if (value == null || value.isEmpty()) continue;
            Element featureElement = parentXml.getOwnerDocument().createElement("attribute");
            childXml.appendChild(featureElement);
            XmlUtil.setAttribute((Element)featureElement, (String)"name", (String)iAttributeFeature.getName(), (boolean)false);
            featureElement.setTextContent(value);
        }
    }
}

