/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer.sax;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.ClosingXmlStreamWriter;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class SaxIbeeResourceWriterGeneric {
    private XMLStreamWriter outWriter;
    private int indent = 0;
    private IProgressMonitor monitor;
    private int objectCountTotal;
    private int objectCount;
    private int lastProgress;

    public void write(IbeeResource resource, File file) {
        this.write(resource, file, this.monitor, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(IbeeResource resource, File file, IProgressMonitor monitor, ILogHandler userIo) throws IbeeException {
        block20: {
            this.monitor = monitor;
            this.objectCountTotal = this.countElements(resource);
            this.objectCount = 0;
            this.lastProgress = 0;
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try {
                    ZipOutputStream outputStream = new ZipOutputStream(FileUtil.openOutputStream((File)file));
                    try {
                        try (ClosingXmlStreamWriter writer = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8"));){
                            this.outWriter = writer;
                            try {
                                if (monitor != null) {
                                    monitor.beginTask("Save Andromeda Model", 100);
                                }
                                outputStream.putNextEntry(new ZipEntry("_model.xml"));
                                this.outWriter.writeStartDocument();
                                this.writeResource(resource);
                                this.outWriter.writeEndDocument();
                                this.outWriter.flush();
                                outputStream.closeEntry();
                            }
                            finally {
                                if (monitor != null) {
                                    monitor.done();
                                }
                            }
                        }
                        if (outputStream == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (outputStream == null) throw throwable;
                        outputStream.close();
                        throw throwable;
                    }
                    outputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (!(e instanceof IbeeException)) throw new IbeeException(e);
                throw (IbeeException)e;
            }
        }
        resource.setDirty(false);
    }

    private void writeResource(IbeeResource resource) throws ManualInteruptionException, XMLStreamException {
        IElement root = resource.getRoot();
        if (root != null) {
            this.writeElement(root);
        }
    }

    private void writeElement(IElement element) throws XMLStreamException, ManualInteruptionException {
        this.nl();
        this.outWriter.writeStartElement("element");
        this.outWriter.writeAttribute("domain", element.giGetElementType().getDomain().getName());
        this.outWriter.writeAttribute("id", "" + element.giGetElementId());
        this.outWriter.writeAttribute("type", element.giGetElementType().getName());
        ++this.indent;
        this.writeAttributes(element);
        this.writeChildElements(element);
        this.writeChildLists(element);
        --this.indent;
        this.nl();
        this.outWriter.writeEndElement();
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
                if (this.monitor.isCanceled()) {
                    throw new ManualInteruptionException("Reading procedure has been canceled");
                }
            }
        }
    }

    private void nl() throws XMLStreamException {
        this.outWriter.writeCharacters(FileUtil.lineSeparator());
        char[] chars = new char[this.indent];
        int i = 0;
        while (i < this.indent) {
            chars[i] = 32;
            ++i;
        }
        String s = new String(chars);
        this.outWriter.writeCharacters(s);
    }

    private void writeAttributes(IElement element) throws XMLStreamException {
        for (IAttributeFeature feature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttribute(feature);
            if (value == null || value.length() <= 0) continue;
            this.nl();
            this.outWriter.writeStartElement("attribute");
            this.outWriter.writeAttribute("name", feature.getName());
            this.outWriter.writeCharacters(element.giGetAttribute(feature));
            this.outWriter.writeEndElement();
        }
    }

    private void writeChildLists(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IListFeature<IElement> feature : element.giGetElementType().getListFeatures()) {
            Collection<IElement> children = element.giGetList(feature).getElements();
            if (children == null || children.size() <= 0) continue;
            this.nl();
            this.outWriter.writeStartElement("list");
            this.outWriter.writeAttribute("name", feature.getName());
            if (feature.isContainment()) {
                ++this.indent;
                for (IElement child : children) {
                    this.writeElement(child);
                }
                --this.indent;
                this.nl();
            } else {
                StringBuffer buf = new StringBuffer();
                for (IElement child : children) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(child.giGetElementId());
                }
                this.outWriter.writeCharacters(buf.toString());
            }
            this.outWriter.writeEndElement();
        }
    }

    private void writeChildElements(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IElementFeature<IElement> feature : element.giGetElementType().getElementFeatures()) {
            IElement child = element.giGetElement(feature).getElement();
            if (child == null) continue;
            this.nl();
            this.outWriter.writeStartElement("child");
            this.outWriter.writeAttribute("name", feature.getName());
            if (feature.isContainment()) {
                ++this.indent;
                this.writeElement(child);
                --this.indent;
                this.nl();
            } else {
                this.outWriter.writeCharacters("" + child.giGetElementId());
            }
            this.outWriter.writeEndElement();
        }
    }

    public int countElements(IbeeResource resource) {
        return resource.getSize();
    }
}

