/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.resource.writer.sax2;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.IElementHandle;
import net.edgemind.ibee.core.iml.model.IListHandle;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.LibraryDescriptor;
import net.edgemind.ibee.core.resource.ResourceIOException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class XmlImfResourceWriterSax2 {
    private XMLStreamWriter writer;
    private IProgressMonitor monitor;
    private int objectCountTotal;
    private int objectCount;
    private int lastProgress;
    private boolean printNewLines = false;
    private boolean zipped = true;
    private boolean writeElementIds = true;
    private Function<File, File> libAdapter;

    public boolean printNewLines() {
        return this.printNewLines;
    }

    public void printNewLines(boolean printNewLines) {
        this.printNewLines = printNewLines;
    }

    public void writeElementIds(boolean writeIds) {
        this.writeElementIds = writeIds;
    }

    public void setZipped(boolean value) {
        this.zipped = value;
    }

    public void write(IbeeResource resource, File file) throws ResourceIOException {
        this.write(resource, file, this.monitor, null);
    }

    public void write(IbeeResource resource, File file, IProgressMonitor monitor, ILogHandler logHandler) throws ResourceIOException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream outputStream = this.createFileOutputStream(file);){
                this.performWrite(resource, outputStream, monitor, logHandler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            throw new ResourceIOException(exception);
        }
    }

    public void write(IbeeResource resource, OutputStream outputStream) {
        this.write(resource, outputStream, null, null);
    }

    public void write(IbeeResource resource, OutputStream outputStream, IProgressMonitor monitor, ILogHandler logHandler) throws ResourceIOException {
        try {
            this.performWrite(resource, outputStream, monitor, logHandler);
        }
        catch (IOException e) {
            throw new ResourceIOException(e);
        }
    }

    private void performWrite(IbeeResource resource, OutputStream outputStream, IProgressMonitor monitor, ILogHandler logHandler) throws IOException {
        if (this.zipped) {
            outputStream = this.createZippedOutputStream(outputStream);
        }
        this.monitor = monitor;
        this.objectCountTotal = this.countElements(resource);
        this.objectCount = 0;
        this.lastProgress = 0;
        try {
            this.writer = null;
            try {
                if (monitor != null) {
                    monitor.beginTask("Save Ibee Resource", 100);
                }
                this.writer = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));
                this.writer.writeStartDocument();
                this.writer.writeStartElement("resource");
                this.writeMetaSection(resource);
                this.writeLibraries(resource);
                this.writeResource(resource);
                this.nl();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
                if (this.writer != null) {
                    this.writer.flush();
                    if (outputStream != null) {
                        if (outputStream instanceof ZipOutputStream) {
                            ((ZipOutputStream)outputStream).closeEntry();
                        }
                        outputStream.close();
                    }
                    this.writer.close();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof IbeeException) {
                throw (IbeeException)e;
            }
            throw new IbeeException(e);
        }
        resource.setDirty(false);
    }

    private OutputStream createFileOutputStream(File file) throws IOException {
        return FileUtil.openOutputStream((File)file);
    }

    private OutputStream createZippedOutputStream(OutputStream stream) throws IOException {
        ZipOutputStream outputStream = new ZipOutputStream(stream);
        outputStream.putNextEntry(new ZipEntry("_model.xml"));
        return outputStream;
    }

    private void writeLibraries(IbeeResource resource) throws IOException, XMLStreamException {
        List<IbeeLibrary> libs = resource.getLibraries();
        if (libs.size() == 0) {
            return;
        }
        this.nl();
        this.writer.writeStartElement("libraries");
        for (IbeeLibrary library : libs) {
            File file;
            this.nl();
            LibraryDescriptor desc = resource.getDescriptor(library);
            this.writer.writeStartElement("library");
            this.nl();
            this.writer.writeStartElement("name");
            this.writer.writeCharacters(library.getName());
            this.writer.writeEndElement();
            this.nl();
            this.writer.writeStartElement("url");
            String libUrl = desc.getUrl();
            if (libUrl != null && this.libAdapter != null && (file = this.libAdapter.apply(new File(libUrl))) != null) {
                libUrl = file.getPath();
            }
            if (libUrl != null) {
                this.writer.writeCharacters(libUrl);
            }
            this.writer.writeEndElement();
            this.nl();
            this.writer.writeEndElement();
        }
        this.nl();
        this.writer.writeEndElement();
    }

    private void writeMetaSection(IbeeResource resource) throws IOException, XMLStreamException {
        this.writeMetaSection("xml-writer-name", "SaxResourceWriter");
        this.writeMetaSection("xml-writer-version", "2.0");
        IElement e = resource.getRoot();
        if (e != null) {
            IDomain domain = e.giGetElementType().getDomain();
            this.writeMetaSection("domain-name", domain.getName() != null ? domain.getName() : "???");
            this.writeMetaSection("domain-version", domain.getVersion() != null ? domain.getVersion() : "1.0");
        }
    }

    private void writeMetaSection(String name, String value) throws IOException, XMLStreamException {
        this.nl();
        this.writer.writeStartElement("meta");
        this.writer.writeAttribute(name, value);
        this.writer.writeEndElement();
    }

    private void writeResource(IbeeResource resource) throws ManualInteruptionException, XMLStreamException {
        IElement root = resource.getRoot();
        if (root != null) {
            this.writeElementDefinition(root, true);
        }
    }

    private void writeElementDefinition(IElement element, boolean isRoot) throws XMLStreamException, ManualInteruptionException {
        boolean hasChilds;
        this.nl();
        Object tagName = isRoot ? "root" : element.giGetElementType().getName();
        String prefix = null;
        if (element.giGetParent() == null) {
            prefix = element.giGetElementType().getDomain().getName();
        } else if (element.giGetParent().giGetElementType().getDomain() != element.giGetElementType().getDomain()) {
            prefix = element.giGetElementType().getDomain().getName();
        }
        if (prefix != null) {
            tagName = prefix + ":" + (String)tagName;
        }
        if (hasChilds = this.hasChilds(element)) {
            this.writer.writeStartElement((String)tagName);
        } else {
            this.writer.writeEmptyElement((String)tagName);
        }
        if (this.writeElementIds) {
            this.writer.writeAttribute("_id", "" + element.giGetElementId());
        }
        if (element.giGetParent() == null) {
            this.writer.writeAttribute("_type", element.giGetElementType().getName());
            this.writeNsDeclarations(element.giGetElementType().getDomain());
        }
        this.writeElementContent(element);
        if (hasChilds) {
            this.writer.writeEndElement();
        }
        if (this.monitor != null) {
            ++this.objectCount;
            int progress = this.objectCount * 100 / this.objectCountTotal;
            int delta = progress - this.lastProgress;
            if (delta > 0) {
                this.monitor.worked(delta);
                this.lastProgress = progress;
                if (this.monitor.isCanceled()) {
                    throw new ManualInteruptionException("Reading procedure has been canceled");
                }
            }
        }
    }

    public boolean hasChilds(IElement element) {
        for (IListFeature<IElement> iListFeature : element.giGetElementType().getListFeatures()) {
            IListHandle<IElement> listHandle = element.giGetList(iListFeature);
            if (listHandle == null || listHandle.isEmpty()) continue;
            return true;
        }
        for (IElementFeature iElementFeature : element.giGetElementType().getElementFeatures()) {
            Object child;
            IElementHandle elHandle = element.giGetElement(iElementFeature);
            if (elHandle == null || (child = elHandle.getElement(false)) == null) continue;
            return true;
        }
        return false;
    }

    private void writeNsDeclarations(IDomain domain) throws XMLStreamException {
        String ns = domain.getName();
        this.writer.writeAttribute("xmlns:" + ns, "https://net.ibee.imf/" + ns);
        for (IDomain inherited : domain.getInheritedDomains()) {
            ns = inherited.getName();
            this.writer.writeAttribute("xmlns:" + ns, "https://net.ibee.imf/" + ns);
        }
    }

    private void writeElementContent(IElement element) throws XMLStreamException, ManualInteruptionException {
        this.writeAttributes(element);
        this.writeChildElements(element);
        this.writeChildLists(element);
    }

    private void nl() throws XMLStreamException {
        if (this.printNewLines) {
            this.writer.writeCharacters(FileUtil.lineSeparator());
        }
    }

    private void writeAttributes(IElement element) throws XMLStreamException {
        for (IAttributeFeature feature : element.giGetElementType().getAttributeFeatures()) {
            String value = element.giGetAttributeRaw(feature);
            if (value == null || value.length() <= 0) continue;
            this.writer.writeAttribute(feature.getName(), value);
        }
    }

    private void writeChildLists(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IListFeature<IElement> feature : element.giGetElementType().getListFeatures()) {
            Collection<IElement> children = element.giGetList(feature).getElements();
            if (children == null || children.size() <= 0) continue;
            this.nl();
            this.writer.writeStartElement(feature.getName());
            if (feature.isContainment()) {
                for (IElement child : children) {
                    this.writeElementDefinition(child, false);
                }
                this.nl();
            } else {
                StringBuffer buf = new StringBuffer();
                for (IElement child : children) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(child.giGetElementId());
                }
                this.writer.writeAttribute("reflist", "true");
                this.writer.writeCharacters(buf.toString());
            }
            this.writer.writeEndElement();
        }
    }

    private void writeChildElements(IElement element) throws XMLStreamException, ManualInteruptionException {
        for (IElementFeature<IElement> feature : element.giGetElementType().getElementFeatures()) {
            IElement child = element.giGetElement(feature).getElement();
            if (child == null) continue;
            this.nl();
            String tagName = feature.getName();
            this.writer.writeStartElement(tagName);
            if (feature.isContainment()) {
                boolean explicitTypeDeclaration = true;
                if (feature.getTypes().size() == 1 && child.giGetElementType() == feature.getTypes().get(0)) {
                    explicitTypeDeclaration = false;
                }
                if (this.writeElementIds) {
                    this.writer.writeAttribute("_id", "" + child.giGetElementId());
                }
                if (explicitTypeDeclaration) {
                    String domain = "";
                    if (child.giGetElementType().getDomain() != element.giGetElementType().getDomain()) {
                        domain = child.giGetElementType().getDomain().getName();
                    }
                    if (!domain.isEmpty()) {
                        this.writer.writeAttribute("_type", domain + "." + child.giGetElementType().getName());
                    } else {
                        this.writer.writeAttribute("_type", child.giGetElementType().getName());
                    }
                }
                this.writeElementContent(child);
                this.nl();
            } else {
                this.writer.writeAttribute("ref", "true");
            }
            this.writer.writeEndElement();
        }
    }

    public int countElements(IbeeResource resource) {
        return resource.getSize();
    }

    public void setLibAdapter(Function<File, File> libAdapter) {
        this.libAdapter = libAdapter;
    }
}

