/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.util.ArrayList;
import net.edgemind.ibee.core.iml.domain.IDomain;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.iml.model.impl.ElementHandleImpl;
import net.edgemind.ibee.core.iml.model.impl.ListHandleImpl;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.resource.impl.IbeeResourceImpl;
import net.edgemind.ibee.util.xml.DomElement;

public class DomDecoder {
    IDomain domain;

    public IbeeResource decode(DomElement model, IDomain domain) {
        this.domain = domain;
        IbeeResource res = IbeeResourceImpl.create();
        for (DomElement domElement : model.getChildren("e")) {
            String typeName = domElement.getAttribute("type");
            IElementType<?> type = domain.getType(typeName);
            if (type == null) continue;
            Object element = res.create(type);
            this.parseAttributes(domElement, (IElement)element);
            this.parseElementFeatures(domElement, (IElement)element);
            this.parseListFeatures(domElement, (IElement)element);
        }
        long rootId = model.getLongAttr("__root", -1L);
        IElement root = res.getObject(rootId);
        if (root != null) {
            res.setRoot(root);
        }
        return res;
    }

    private void parseAttributes(DomElement domElement, IElement element) {
        for (String attr : domElement.attributes.keySet()) {
            element.giSetAttribute(attr, (String)domElement.attributes.get(attr));
        }
    }

    private void parseElementFeatures(DomElement domElement, IElement element) {
        for (DomElement domList : domElement.getChildren("element")) {
            String feature = domList.getAttribute("name");
            ElementHandleImpl handle = (ElementHandleImpl)element.giGetElement(feature);
            String id = domList.getAttribute("id");
            if (id == null) continue;
            handle.setElementByIdInject(new Long(id), false);
        }
    }

    private void parseListFeatures(DomElement domElement, IElement element) {
        for (DomElement domList : domElement.getChildren("list")) {
            String feature = domList.getAttribute("name");
            ListHandleImpl handle = (ListHandleImpl)element.giGetList(feature);
            String ids = domList.getAttribute("ids");
            if (ids == null) continue;
            String[] idList = ids.split(",");
            ArrayList<Long> longIds = new ArrayList<Long>();
            String[] stringArray = idList;
            int n = idList.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                longIds.add(new Long(id));
                ++n2;
            }
            handle.setAllElementsByIdInject(longIds, false);
        }
    }
}

