/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.util.Collection;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IContent;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.xml.DomElement;

public class DomEncoder {
    public DomElement encode(IbeeResource res) {
        DomElement root = new DomElement("root");
        for (IElement e : res.getAllObjects(-1L, true)) {
            DomElement jsElement = new DomElement("e");
            jsElement.attr("type", e.giGetElementType().getName());
            this.encode(e, jsElement);
            root.children.add(jsElement);
        }
        IElement rootElement = res.getRoot();
        if (rootElement != null) {
            root.setLongAttr("__root", rootElement.giGetElementId());
        }
        return root;
    }

    private void encode(IElement e, DomElement parent) {
        DomElement jsElement;
        IContent handle;
        IElementType<? extends IElement> type = e.giGetElementType();
        for (IAttributeFeature iAttributeFeature : type.getAttributeFeatures()) {
            String value = e.giGetAttribute(iAttributeFeature);
            if (value == null || value.length() <= 0) continue;
            DomElement jsElement2 = new DomElement("attr");
            parent.children.add(jsElement2);
            jsElement2.attr("name", iAttributeFeature.getName());
            jsElement2.attr("value", value);
        }
        for (IElementFeature iElementFeature : type.getElementFeatures()) {
            handle = e.giGetElement(iElementFeature);
            Object child = handle.getElement();
            if (child == null) continue;
            jsElement = new DomElement("element");
            parent.children.add(jsElement);
            jsElement.attr("name", iElementFeature.getName());
            jsElement.attr("id", "" + child.giGetElementId());
        }
        for (IListFeature iListFeature : type.getListFeatures()) {
            handle = e.giGetList(iListFeature);
            Collection children = handle.getElements();
            if (children.size() <= 0) continue;
            jsElement = new DomElement("list");
            parent.children.add(jsElement);
            jsElement.attr("name", iListFeature.getName());
            StringBuilder ids = new StringBuilder();
            boolean first = true;
            for (IElement child : children) {
                if (first) {
                    first = false;
                } else {
                    ids.append(",");
                }
                ids.append("" + child.giGetElementId());
            }
            jsElement.attr("ids", ids.toString());
        }
    }
}

