/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.domain.IElementType;
import net.edgemind.ibee.core.iml.domain.ImfComponentType;
import net.edgemind.ibee.core.library.IbeeLibrary;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.core.util.Selection;

public class ImfFreeNameGetter {
    public int maxNameLength = -1;

    public int getNameLength() {
        return this.maxNameLength;
    }

    public void setNameLength(int nameLength) {
        this.maxNameLength = nameLength;
    }

    public String findFreeName(IbeeResource resource, IElementType<?> type, String prefix, String name, String suffix) throws IbeeException {
        return this.findFreeName(resource, type, prefix, name, suffix, false);
    }

    public String findFreeName(IbeeResource resource, IElementType<?> type, String prefix, String name, String suffix, boolean indexRequired) throws IbeeException {
        return this.findFreeName(resource, type, prefix, name, suffix, indexRequired, false);
    }

    public String findFreeName(IbeeResource resource, IElementType<?> type, String prefix, String name, String suffix, boolean indexRequired, boolean withLibs) throws IbeeException {
        prefix = this.normalize(prefix);
        suffix = this.normalize(suffix);
        name = this.normalize(name);
        if (this.truncationIsEnabled()) {
            return this.findTruncatedFreeName(resource, type, prefix, name, suffix, indexRequired, withLibs);
        }
        return this.findFreeNameInternal(resource, type, prefix, name, suffix, indexRequired, withLibs);
    }

    private String findTruncatedFreeName(IbeeResource resource, IElementType<?> type, String prefix, String name, String suffix, boolean indexRequired, boolean withLibs) throws IbeeException {
        int nbCharsToRemoveStart;
        String fullName = this.getFullName(prefix, name, suffix);
        int nbCharsToRemove = nbCharsToRemoveStart = Math.max(fullName.length() - this.maxNameLength, 0);
        while (nbCharsToRemove < name.length()) {
            String truncatedName = name.substring(0, name.length() - nbCharsToRemove);
            String foundFreeName = this.findFreeNameInternal(resource, type, prefix, truncatedName, suffix, indexRequired, withLibs);
            if (foundFreeName != null) {
                return foundFreeName;
            }
            ++nbCharsToRemove;
        }
        throw new IbeeException(String.format("Find free name for '%s' failed. No free name available for '%s' respecting prefix '%s', suffix '%s' and maximum characters %d", fullName, name, prefix, suffix, this.maxNameLength));
    }

    private String findFreeNameInternal(IbeeResource resource, IElementType<?> type, String prefix, String name, String suffix, boolean indexRequired, boolean withLibs) {
        if (!indexRequired) {
            String freeName = this.getFullName(prefix, name, suffix);
            if (!this.respectsMaximumCharacters(freeName)) {
                return null;
            }
            if (this.noSuchElementExists(freeName, type, resource, withLibs)) {
                return freeName;
            }
        }
        int index = 1;
        String freeName;
        while (this.respectsMaximumCharacters(freeName = this.getFullName(prefix, name + index, suffix))) {
            if (this.noSuchElementExists(freeName, type, resource, withLibs)) {
                return freeName;
            }
            ++index;
        }
        return null;
    }

    private boolean truncationIsEnabled() {
        return this.maxNameLength > 0;
    }

    private boolean truncationIsDisabled() {
        return !this.truncationIsEnabled();
    }

    private String getFullName(String prefix, String name, String suffix) {
        return prefix + name + suffix;
    }

    private boolean respectsMaximumCharacters(String s) {
        if (this.truncationIsDisabled()) {
            return true;
        }
        return s.length() <= this.maxNameLength;
    }

    private boolean noSuchElementExists(String name, IElementType<?> type, IbeeResource resource, boolean withLibs) {
        Selection components = resource.getComponents((ImfComponentType)type, name);
        if (components != null && components.size() > 0) {
            return false;
        }
        if (withLibs) {
            for (IbeeLibrary lib : resource.getLibraries()) {
                IbeeResource libResource = lib.getResource();
                if (libResource == null || this.noSuchElementExists(name, type, libResource, false)) continue;
                return false;
            }
        }
        return true;
    }

    private String normalize(String s) {
        if (s == null) {
            s = "";
        }
        return s;
    }
}

