/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.edgemind.ibee.core.iml.domain.IAttributeFeature;
import net.edgemind.ibee.core.iml.domain.IElementFeature;
import net.edgemind.ibee.core.iml.domain.IListFeature;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.core.resource.GlobalKey;

public class ImfNameGetter {
    private StringBuffer buf;

    public String getName(IElement e) {
        this.buf = new StringBuffer();
        this.encodeValue(e);
        return this.buf.toString();
    }

    private void encodeValue(IElement e) {
        this.encodeAttributeFeatures(e);
        this.encodeListFeatures(e);
        this.encodeElementFeatures(e);
    }

    private void encodeAttributeFeatures(IElement e) {
        ArrayList<IAttributeFeature> attributes = new ArrayList<IAttributeFeature>(e.giGetElementType().getAttributeFeatures());
        boolean first = true;
        for (IAttributeFeature feature : attributes) {
            if (!feature.isKey()) continue;
            if (first) {
                first = false;
            } else {
                this.buf.append("; ");
            }
            this.encodeAttributeFeature(e, feature);
        }
    }

    private void encodeAttributeFeature(IElement e, IAttributeFeature feature) {
        String attrValue = e.giGetAttribute(feature);
        if (attrValue != null && attrValue.length() > 0) {
            this.buf.append(attrValue);
        }
    }

    private void encodeListFeatures(IElement e) {
        List<IListFeature<IElement>> listFeatures = e.giGetElementType().getListFeatures();
        boolean first = true;
        for (IListFeature<IElement> feature : listFeatures) {
            if (!feature.isKey()) continue;
            if (first) {
                first = false;
            } else {
                this.buf.append("; ");
            }
            this.encodeListFeature(e, feature);
        }
    }

    private void encodeListFeature(IElement e, IListFeature<? extends IElement> feature) {
        ArrayList<? extends IElement> copy;
        Collection<? extends IElement> childrenList = e.giGetList(feature).getElements();
        if (childrenList == null) {
            return;
        }
        boolean isOrdered = feature.isOrdered();
        if (isOrdered) {
            copy = new ArrayList<IElement>(childrenList);
        } else {
            copy = new ArrayList<IElement>(childrenList);
            Collections.sort(copy, new Comparator<IElement>(){

                @Override
                public int compare(IElement o1, IElement o2) {
                    return GlobalKey.createFrom(o1).compareToEquals(GlobalKey.createFrom(o2));
                }
            });
        }
        if (copy != null) {
            boolean first = true;
            for (IElement iElement : copy) {
                boolean isHardRef;
                if (first) {
                    first = false;
                } else {
                    this.buf.append(", ");
                }
                boolean bl = isHardRef = iElement.giGetParent() != e;
                if (isHardRef) {
                    this.encodeHardReference(iElement);
                    continue;
                }
                this.encodeValue(iElement);
            }
        }
    }

    private void encodeElementFeatures(IElement e) {
        List<IElementFeature<IElement>> elementFeatures = e.giGetElementType().getElementFeatures();
        boolean first = true;
        for (IElementFeature<IElement> feature : elementFeatures) {
            if (!feature.isKey()) continue;
            if (first) {
                first = false;
            } else {
                this.buf.append("; ");
            }
            this.encodeElementFeature(e, feature);
        }
    }

    private void encodeElementFeature(IElement e, IElementFeature<? extends IElement> feature) {
        boolean isHardRef;
        IElement child = e.giGetElement(feature).getElement();
        if (child == null) {
            return;
        }
        boolean bl = isHardRef = child.giGetParent() != e;
        if (isHardRef) {
            this.encodeHardReference(child);
        } else {
            this.encodeValue(child);
        }
    }

    private void encodeHardReference(IElement el) {
        boolean first = true;
        for (IAttributeFeature attr : el.giGetElementType().getAttributeFeatures()) {
            if (!attr.isKey()) continue;
            if (first) {
                first = false;
            } else {
                this.buf.append(", ");
            }
            this.buf.append(el.giGetAttribute(attr));
        }
    }
}

