/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.edgemind.ibee.util.misc.ClassUtil;
import net.edgemind.ibee.util.misc.IFilter;

public class Selection<T>
implements Iterable<T>,
Collection<T> {
    protected List<T> selection = new ArrayList<T>();

    public Selection() {
    }

    public Selection(T sel) {
        this.selection.add(sel);
    }

    public Selection(Collection<? extends T> sel) {
        if (sel != null) {
            this.selection.addAll(sel);
        }
    }

    public <U extends T> Selection<U> getSelection(Class<U> clazz) {
        List<U> res = this.getElements(clazz);
        return new Selection<U>(res);
    }

    public <U> List<U> getElements(Class<U> clazz) {
        ArrayList<T> res = new ArrayList<T>();
        for (T next : this.selection) {
            if (next == null || !ClassUtil.inherits(next.getClass(), clazz)) continue;
            res.add(next);
        }
        return res;
    }

    public List<T> getElements() {
        return this.selection;
    }

    public List<T> toList() {
        return new ArrayList<T>(this.getElements());
    }

    public Set<T> toSet() {
        return new HashSet<T>(this.getElements());
    }

    @Override
    public void clear() {
        this.selection.clear();
    }

    public void add(T ... el) {
        T[] TArray = el;
        int n = el.length;
        int n2 = 0;
        while (n2 < n) {
            T e = TArray[n2];
            this.selection.add(e);
            ++n2;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> sel) {
        return this.selection.addAll(sel);
    }

    public void addAll(Selection<T> sel) {
        this.selection.addAll(sel.getElements());
    }

    @Override
    public boolean contains(Object el) {
        return this.selection.contains(el);
    }

    @Override
    public boolean remove(Object el) {
        return this.selection.remove(el);
    }

    public void insert(T el, int pos) {
        this.selection.add(pos, el);
    }

    @Override
    public int size() {
        return this.selection.size();
    }

    public T get(int index) {
        return this.selection.get(index);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Selection) {
            return this.getElements().equals(((Selection)obj).getElements());
        }
        if (obj instanceof List) {
            return this.getElements().equals(obj);
        }
        return this.getElements().equals(obj);
    }

    public T first() {
        if (!this.selection.isEmpty()) {
            return this.selection.get(0);
        }
        return null;
    }

    public <U> U first(Class<U> clazz) {
        for (T next : this.selection) {
            if (!ClassUtil.inherits(next.getClass(), clazz)) continue;
            return (U)next;
        }
        return null;
    }

    public int indexOf(T object) {
        return this.selection.indexOf(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.selection.iterator();
    }

    @Override
    public boolean add(T e) {
        return this.selection.add(e);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.selection.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.selection.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.selection.retainAll(arg0);
    }

    @Override
    public Object[] toArray() {
        return this.selection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.selection.toArray(arg0);
    }

    public void filter(IFilter<? super T> filter) {
        if (filter == null) {
            return;
        }
        this.selection = this.selection.stream().filter((? super T e) -> filter.accept(e)).collect(Collectors.toList());
    }
}

