/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import java.util.ArrayList;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.style.DefaultStyleEngine;
import net.edgemind.ibee.dita.style.StyleElement;
import net.edgemind.ibee.dita.style.StyleEngine;
import net.edgemind.ibee.dita.style.WordStyleUtil;
import org.docx4j.wml.P;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;

public abstract class ADitaElementWordStylist {
    protected StyleEngine styleEngine = new DefaultStyleEngine();

    public void setStyleEngine(StyleEngine engine) {
        this.styleEngine = engine;
    }

    protected void applyStyle(P p, DitaElement ditaE) {
        this.applyStyle(p, ditaE, null);
    }

    protected void applyStyle(R run, DitaElement ditaE) {
        this.applyStyle(run, ditaE, null);
    }

    protected void applyStyle(R run, DitaElement ditaE, String[] additionalStyles) {
        Boolean isItalic;
        Boolean isUnderline;
        Boolean isBold;
        Double textSize;
        StyleElement styleElement = this.createStyleElement(ditaE, additionalStyles);
        String color = this.styleEngine.getColor(styleElement);
        if (color != null) {
            WordStyleUtil.setColor(color, run);
        }
        if ((textSize = this.styleEngine.getTextSize(styleElement)) != null) {
            WordStyleUtil.setTextSize((int)textSize.doubleValue(), run);
        }
        if ((isBold = Boolean.valueOf(this.styleEngine.isBold(styleElement))) != null) {
            WordStyleUtil.setBold(isBold, run);
        }
        if ((isUnderline = Boolean.valueOf(this.styleEngine.isUnderline(styleElement))) != null) {
            WordStyleUtil.setUnderline(isUnderline, run);
        }
        if ((isItalic = Boolean.valueOf(this.styleEngine.isItalic(styleElement))) != null) {
            WordStyleUtil.setItalic(isItalic, run);
        }
    }

    protected void applyStyle(P p, DitaElement element, String[] additionalStyles) {
        String externalStyle;
        StyleElement styleElement = this.createStyleElement(element, additionalStyles);
        Double before = this.styleEngine.getMarginTop(styleElement);
        Double after = this.styleEngine.getMarginBottom(styleElement);
        Double lineSpacing = this.styleEngine.getLineSpacing(styleElement);
        if (lineSpacing != null || before != null || after != null) {
            double beforeValue = this.getValue(before, -1.0);
            double afterValue = this.getValue(after, -1.0);
            double lineSpacingValue = this.getValue(lineSpacing, -1.0);
            WordStyleUtil.setLineSpacing((int)beforeValue, (int)afterValue, (int)lineSpacingValue, p);
        }
        Double left = this.styleEngine.getMarginLeft(styleElement);
        Double right = this.styleEngine.getMarginRight(styleElement);
        if (left != null || right != null) {
            double leftValue = this.getValue(left, -1.0);
            double rightValue = this.getValue(right, -1.0);
            WordStyleUtil.setIndention((int)leftValue, (int)rightValue, p);
        }
        Integer numberingLevel = this.styleEngine.getNumberingLevel(styleElement);
        Integer numberingId = this.styleEngine.getNumberingId(styleElement);
        String pStyle = this.styleEngine.getNumberingStyle(styleElement);
        if (numberingLevel != null && numberingId != null && pStyle != null) {
            WordStyleUtil.createNumbering(p, numberingLevel, numberingId, pStyle);
        } else if (numberingLevel != null && numberingId != null) {
            WordStyleUtil.createNumbering(p, numberingLevel, numberingId);
        } else if (numberingLevel != null) {
            WordStyleUtil.createNumbering(p, numberingLevel, 1);
        }
        StyleEngine.Alignment justify = this.styleEngine.getAlignment(styleElement);
        if (justify != null) {
            WordStyleUtil.setAlignment(justify, p);
        }
        if ((externalStyle = this.styleEngine.getExternalStyle(styleElement)) != null) {
            PPrBase.PStyle rStyle = new PPrBase.PStyle();
            rStyle.setVal(externalStyle);
            WordStyleUtil.getProperties(p).setPStyle(rStyle);
        }
    }

    protected StyleElement createStyleElement(DitaElement ditaE, String[] additionalStyles) {
        StyleElement element = new StyleElement();
        element.setType(ditaE.getClass());
        ArrayList<String> styleClasses = new ArrayList<String>();
        for (String styleId : ditaE.getOutputClasses()) {
            if ((styleId = styleId.trim()).length() == 0) continue;
            styleClasses.add(styleId);
        }
        if (additionalStyles != null) {
            String[] stringArray = additionalStyles;
            int n = additionalStyles.length;
            int n2 = 0;
            while (n2 < n) {
                String styleId;
                styleId = stringArray[n2];
                styleClasses.add(styleId);
                ++n2;
            }
        }
        element.addClasses(styleClasses);
        return element;
    }

    protected double getValue(Double d, double defaultValue) {
        if (d != null) {
            return d;
        }
        return defaultValue;
    }
}

