/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import java.io.File;
import java.math.BigInteger;
import net.edgemind.ibee.dita.builder.word.ADitaElementWordBuilder;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaXRef;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;

public class DitaRefWordBuilder
extends ADitaElementWordBuilder<DitaXRef> {
    @Override
    public ContentAccessor createNode(DitaXRef dita, ContentAccessor parent) {
        P.Hyperlink hyperlink = this.factory.createPHyperlink();
        if (dita.getText() != null && dita.getText().contains("bib01]")) {
            System.out.append("df");
            try {
                this.main(null);
            }
            catch (Docx4JException e) {
                e.printStackTrace();
            }
        }
        String anchorId = dita.getHref().replaceAll("^#", "");
        String linkText = dita.getText();
        R run = this.factory.createR();
        Text text = this.factory.createText();
        text.setValue(linkText);
        run.getContent().add(text);
        hyperlink.setAnchor(anchorId);
        hyperlink.getContent().add(run);
        if (!(parent instanceof P)) {
            P p = this.factory.createP();
            parent.getContent().add(p);
            parent = p;
        }
        parent.getContent().add(hyperlink);
        this.applyStyle(run, (DitaElement)dita, new String[]{"reference"});
        return parent;
    }

    public void main(String[] args) throws Docx4JException {
        try {
            WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
            MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
            P bookmarkParagraph = this.factory.createP();
            CTBookmark bookmarkStart = this.factory.createCTBookmark();
            bookmarkStart.setId(BigInteger.valueOf(1L));
            bookmarkStart.setName("bib_01");
            R bookmarkRun = this.factory.createR();
            Text bookmarkText = this.factory.createText();
            bookmarkText.setValue("This is bookmarked text.");
            bookmarkRun.getContent().add(bookmarkText);
            CTMarkupRange bookmarkEnd = this.factory.createCTMarkupRange();
            bookmarkEnd.setId(BigInteger.valueOf(1L));
            bookmarkParagraph.getContent().add(bookmarkStart);
            bookmarkParagraph.getContent().add(bookmarkRun);
            bookmarkParagraph.getContent().add(bookmarkEnd);
            documentPart.addObject((Object)bookmarkParagraph);
            P linkParagraph = this.factory.createP();
            P.Hyperlink hyperlink = this.factory.createPHyperlink();
            hyperlink.setAnchor("bib_01");
            R hyperlinkRun = this.factory.createR();
            Text hyperlinkText = this.factory.createText();
            hyperlinkText.setValue("Go to Bookmark");
            hyperlinkRun.getContent().add(hyperlinkText);
            hyperlink.getContent().add(hyperlinkRun);
            linkParagraph.getContent().add(hyperlink);
            documentPart.addObject((Object)linkParagraph);
            File outputFile = new File("/home/friedlhu/BookmarkWithXref.docx");
            wordMLPackage.save(outputFile);
            System.out.println("Bookmark and cross-reference link added successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

