/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import java.math.BigInteger;
import net.edgemind.ibee.dita.builder.word.ADitaElementWordBuilder;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.style.StyleElement;
import net.edgemind.ibee.dita.style.WordStyleUtil;
import net.edgemind.ibee.dita.writer.word.TableUtil;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblWidth;
import org.docx4j.wml.Tc;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;

public class DitaTableWordBuilder
extends ADitaElementWordBuilder<DitaTable> {
    @Override
    public ContentAccessor createNode(DitaTable dita, ContentAccessor parent) {
        Tbl table = this.factory.createTbl();
        this.applyStyle(table, (DitaElement)dita, null);
        parent.getContent().add(table);
        return table;
    }

    protected void applyStyle(Tbl table, DitaElement element, String[] additionalStyles) {
        Integer tableWidthInPercent;
        StyleElement styleElement = this.createStyleElement(element, additionalStyles);
        if (!element.getOutputClasses().contains("empty_border")) {
            TableUtil.addBorders(table, "000000");
        }
        if ((tableWidthInPercent = this.styleEngine.getWidth(styleElement)) == null) {
            tableWidthInPercent = 100;
        }
        TableUtil.setTableWidthInPercent(table, tableWidthInPercent);
        Double before = this.styleEngine.getMarginTop(styleElement);
        Double after = this.styleEngine.getMarginBottom(styleElement);
        if (before != null || after != null) {
            double beforeValue = this.getValue(before, -1.0);
            double afterValue = this.getValue(after, -1.0);
            WordStyleUtil.setLineSpacing((int)beforeValue, (int)afterValue, table);
        }
    }

    private void applyTableGrid(Tbl table, int width) {
        TblGrid tblGrid = this.factory.createTblGrid();
        int i = 1;
        while (i < 9) {
            TblGridCol col = this.factory.createTblGridCol();
            col.setW(BigInteger.valueOf(i * width));
            tblGrid.getGridCol().add(col);
            ++i;
        }
        table.setTblGrid(tblGrid);
    }

    private void applyGridSpan(Tc cell, int span, int width) {
        TcPr tcPr = this.factory.createTcPr();
        TblWidth tblWidth = this.factory.createTblWidth();
        tblWidth.setType("dxa");
        tblWidth.setW(BigInteger.valueOf(width * span));
        tcPr.setTcW(tblWidth);
        if (span > 1) {
            TcPrInner.GridSpan gridSpan = this.factory.createTcPrInnerGridSpan();
            gridSpan.setVal(BigInteger.valueOf(span));
            tcPr.setGridSpan(gridSpan);
        }
        cell.setTcPr(tcPr);
    }

    private static void setCellWidth(Tc tableCell, int width) {
        TcPr tableCellProperties = new TcPr();
        TblWidth tableWidth = new TblWidth();
        tableWidth.setType("dxa");
        tableWidth.setW(BigInteger.valueOf(width));
        tableCellProperties.setTcW(tableWidth);
        tableCell.setTcPr(tableCellProperties);
    }
}

