/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.builder.word;

import java.io.File;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.dita.builder.dom.AbstractDocumentBuilder;
import net.edgemind.ibee.dita.builder.word.ADitaElementWordBuilder;
import net.edgemind.ibee.dita.builder.word.DitaWordBuilderFactory;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.style.DefaultStyleEngine;
import net.edgemind.ibee.dita.style.PageSize;
import net.edgemind.ibee.dita.style.StyleEngine;
import net.edgemind.ibee.dita.style.WordDefaultStyleCreator;
import net.edgemind.ibee.dita.writer.word.NumberingUtil;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;

public class WordDocumentBuilder
extends AbstractDocumentBuilder<ContentAccessor> {
    protected String currentUrl = "";
    private WordprocessingMLPackage wordMLPackage;
    private StyleEngine styleEngine = new DefaultStyleEngine();
    private ObjectFactory factory;
    private File targetFolder;
    private boolean useTemplating;
    private PageSize pageSize = PageSize.A4_PORTRAIT;

    public WordprocessingMLPackage buildTopicDocument(DitaTopic root) {
        if (this.wordMLPackage == null) {
            try {
                this.wordMLPackage = WordprocessingMLPackage.createPackage();
                WordDefaultStyleCreator creator = new WordDefaultStyleCreator();
                creator.setPageSize(this.pageSize);
                creator.createDefaultStyle(this.wordMLPackage);
                NumberingUtil.initNumbering(this.wordMLPackage);
            }
            catch (InvalidFormatException e) {
                throw new IbeeException((Throwable)e);
            }
        }
        this.create(root, null, this.wordMLPackage.getMainDocumentPart());
        return this.wordMLPackage;
    }

    public void setWordMLPackage(WordprocessingMLPackage wordMLPackage) {
        this.wordMLPackage = wordMLPackage;
    }

    public void setFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    public void setTargetFolder(File folder) {
        this.targetFolder = folder;
    }

    public void setStyleEngine(StyleEngine engine) {
        this.styleEngine = engine;
    }

    public void setUseTemplating(boolean useTemplating) {
        this.useTemplating = useTemplating;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    private DitaWordBuilderFactory createBuilderFactory() {
        DitaWordBuilderFactory builderFactory = DitaWordBuilderFactory.createInstance();
        builderFactory.setWordObjectFactory(this.factory);
        builderFactory.setWordProcessingPackage(this.wordMLPackage);
        builderFactory.setStyleEngine(this.styleEngine);
        builderFactory.setPageSize(this.pageSize);
        builderFactory.setTargetFolder(this.targetFolder);
        builderFactory.setUseTemplating(this.useTemplating);
        return builderFactory;
    }

    @Override
    protected <T extends DitaElement> ContentAccessor createNode(T element, DitaElement parentItem, ContentAccessor parentNode) {
        ADitaElementWordBuilder<T> ditaBuilder;
        ContentAccessor node = null;
        if (element instanceof DitaTopic) {
            this.log("word document builder:writing topic '" + ((DitaTopic)element).getTitle() + "', file " + ((DitaTopic)element).getUrl(), LogLevel.INFO);
            this.interruptIfCancelled();
            this.worked(1);
        }
        if ((ditaBuilder = this.createBuilderFactory().getDitaElementBuilder(element)) != null) {
            node = ditaBuilder.createNode(element, parentNode);
        } else {
            this.debug("Ignore " + element.getClass().getSimpleName());
        }
        return node;
    }
}

