/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.exporter;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.exporter.TargetFormat;

public class DitaExporter {
    public void export(String mapFile, TargetFormat format, String targetFolder) throws DitaException {
        String[] cmd = new String[]{"dita", "-i", mapFile, "-f", format.toString(), "-o", targetFolder};
        this.execute(cmd);
    }

    public void exportHtml(String mapFile, String targetFolder, String[] cssSheetPathes) throws DitaException {
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add("dita");
        cmd.add("-i");
        cmd.add(mapFile);
        cmd.add("-f");
        cmd.add(TargetFormat.HTML.toString());
        cmd.add("-o");
        cmd.add(targetFolder);
        String[] stringArray = cssSheetPathes;
        int n = cssSheetPathes.length;
        int n2 = 0;
        while (n2 < n) {
            String cssSheetPath = stringArray[n2];
            cmd.add("-Dargs.css=" + cssSheetPath);
            ++n2;
        }
        cmd.add("-Dargs.csspath=CSS");
        cmd.add("-Dargs.copycss=yes");
        String[] command = new String[cmd.size()];
        cmd.toArray(command);
        LogUtil.log((String)("execute command '" + mapFile), (LogLevel)LogLevel.INFO);
        this.execute(command);
    }

    private void execute(String[] cmd) throws DitaException {
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while (reader.ready()) {
                line = reader.readLine();
                LogUtil.log((String)line, (LogLevel)LogLevel.INFO);
            }
            reader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while (reader.ready()) {
                line = reader.readLine();
                LogUtil.log((String)line, (LogLevel)LogLevel.ERROR);
            }
        }
        catch (Exception e) {
            throw new DitaException(e);
        }
    }
}

