/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.dita.items.DitaDesc;
import net.edgemind.ibee.dita.items.DitaFactory;

public abstract class DitaElement {
    private List<DitaElement> childs;
    private List<String> outputclasses;
    private List<String> tags;
    private String id;
    private Map<String, String> userAttributes;
    private Map<String, String> attributes;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        if (this.tags.contains(tag)) {
            return;
        }
        this.tags.add(tag);
    }

    public List<String> getTags() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return this.tags;
    }

    public boolean hasTag(String tag) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(tag);
    }

    public void removeTag(String tag) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(tag);
    }

    public void addOutputClass(String outputClass) {
        if (outputClass == null) {
            return;
        }
        if (this.outputclasses == null) {
            this.outputclasses = new ArrayList<String>();
        }
        this.outputclasses.add(outputClass);
    }

    public List<String> getOutputClasses() {
        if (this.outputclasses == null) {
            return Collections.emptyList();
        }
        return this.outputclasses;
    }

    public void setDescription(String text) {
        DitaDesc desc = DitaFactory.getInstance().createDesc();
        desc.setText(text);
        this.append(desc);
    }

    public <T extends DitaElement> T getFirstChild(Class<T> clazz) {
        if (this.childs == null) {
            return null;
        }
        for (DitaElement child : this.childs) {
            if (child.getClass() != clazz) continue;
            return (T)child;
        }
        return null;
    }

    public <T extends DitaElement> List<T> getChildren(Class<T> clazz) {
        if (this.childs == null) {
            return Collections.emptyList();
        }
        ArrayList<DitaElement> childs = new ArrayList<DitaElement>();
        for (DitaElement child : this.childs) {
            if (child.getClass() != clazz) continue;
            childs.add(child);
        }
        return childs;
    }

    public List<DitaElement> getChildren() {
        if (this.childs == null) {
            return Collections.emptyList();
        }
        return this.childs;
    }

    public void append(DitaElement child) {
        if (child == null) {
            return;
        }
        if (this.childs == null) {
            this.childs = new ArrayList<DitaElement>();
        }
        this.childs.add(child);
    }

    public void addUserAttribute(String key, String value) {
        if (this.userAttributes == null) {
            this.userAttributes = new HashMap<String, String>();
        }
        this.userAttributes.put(key, value);
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public Map<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public void remove(DitaElement element) {
        if (this.childs == null) {
            return;
        }
        this.childs.remove(element);
    }

    public void clear() {
        if (this.childs == null) {
            return;
        }
        this.childs.clear();
    }
}

