/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.items;

import java.util.List;
import net.edgemind.ibee.dita.items.DitaAlt;
import net.edgemind.ibee.dita.items.DitaColSpec;
import net.edgemind.ibee.dita.items.DitaDesc;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaImage;
import net.edgemind.ibee.dita.items.DitaLi;
import net.edgemind.ibee.dita.items.DitaLink;
import net.edgemind.ibee.dita.items.DitaLinkText;
import net.edgemind.ibee.dita.items.DitaNl;
import net.edgemind.ibee.dita.items.DitaP;
import net.edgemind.ibee.dita.items.DitaPre;
import net.edgemind.ibee.dita.items.DitaRelatedLinks;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaScript;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaShortDesc;
import net.edgemind.ibee.dita.items.DitaString;
import net.edgemind.ibee.dita.items.DitaTBody;
import net.edgemind.ibee.dita.items.DitaTGroup;
import net.edgemind.ibee.dita.items.DitaTHead;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaTitle;
import net.edgemind.ibee.dita.items.DitaToc;
import net.edgemind.ibee.dita.items.DitaTopic;
import net.edgemind.ibee.dita.items.DitaTopicRef;
import net.edgemind.ibee.dita.items.DitaUl;
import net.edgemind.ibee.dita.items.DitaXRef;

public class DitaFactory {
    private static DitaFactory instance;

    public static DitaFactory getInstance() {
        if (instance == null) {
            instance = new DitaFactory();
        }
        return instance;
    }

    public DitaP createP() {
        return new DitaP();
    }

    public DitaPre createPre() {
        return new DitaPre();
    }

    public DitaDesc createDesc() {
        return new DitaDesc();
    }

    public DitaString createString() {
        return new DitaString();
    }

    public DitaString createString(String str) {
        DitaString ris = this.createString();
        ris.setText(str);
        return ris;
    }

    public DitaToc createToc() {
        return new DitaToc();
    }

    public DitaTitle createTitle() {
        return new DitaTitle();
    }

    public DitaUl createUl() {
        return new DitaUl();
    }

    public DitaLi createLi() {
        return new DitaLi();
    }

    public DitaNl createNl() {
        return new DitaNl();
    }

    public DitaTopic createTopic(String url) {
        return new DitaTopic(url);
    }

    public DitaTopicRef createTopicRef(String url) {
        return new DitaTopicRef(url);
    }

    public DitaShortDesc createShortDesc() {
        return new DitaShortDesc();
    }

    public DitaRelatedLinks createRelatedLinks() {
        return new DitaRelatedLinks();
    }

    public DitaLink createLink() {
        return new DitaLink();
    }

    public DitaLinkText createLinkText() {
        return new DitaLinkText();
    }

    public DitaXRef createXRef() {
        return new DitaXRef();
    }

    public DitaTGroup createTGroup() {
        return new DitaTGroup();
    }

    public DitaColSpec createColSpec() {
        return new DitaColSpec();
    }

    public DitaTHead createTHead() {
        return new DitaTHead();
    }

    public DitaTBody createTBody() {
        return new DitaTBody();
    }

    public DitaRow createRow() {
        return new DitaRow();
    }

    public DitaEntry createEntry() {
        return new DitaEntry();
    }

    public DitaTable createTable() {
        return new DitaTable();
    }

    public DitaImage createImage() {
        return new DitaImage();
    }

    public DitaAlt createAlt() {
        return new DitaAlt();
    }

    public DitaScript createScript() {
        return new DitaScript();
    }

    public DitaSection createSection() {
        return new DitaSection();
    }

    public DitaTable createTable(List<String> headers, List<List<Object>> rows) {
        DitaTable table = this.createTable();
        if (headers != null && headers.size() > 0) {
            DitaRow tr = this.createRow();
            table.append(tr);
            headers.forEach(header -> {
                DitaEntry th = this.createEntry();
                tr.append(th);
                th.setText((String)header);
            });
        }
        rows.forEach(row -> {
            DitaRow ReportItemRow = this.createRow();
            table.append(ReportItemRow);
            row.forEach(cell -> {
                DitaEntry th = this.createEntry();
                ReportItemRow.append(th);
                th.setText(String.valueOf(cell));
            });
        });
        return table;
    }
}

