/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.style;

import java.math.BigInteger;
import net.edgemind.ibee.dita.style.PageSize;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;

public class WordDefaultStyleCreator {
    private PageSize pageSize;

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    public void createDefaultStyle(WordprocessingMLPackage wordMLPackage) {
        Style style = wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().getDefaultParagraphStyle();
        ObjectFactory factory = Context.getWmlObjectFactory();
        PPr paragraphProperties = factory.createPPr();
        PPrBase.Spacing sp = factory.createPPrBaseSpacing();
        sp.setLine(BigInteger.valueOf(276L));
        sp.setLineRule(STLineSpacingRule.AUTO);
        paragraphProperties.setSpacing(sp);
        style.setPPr(paragraphProperties);
        Body body = ((Document)wordMLPackage.getMainDocumentPart().getJaxbElement()).getBody();
        PageDimensions page = new PageDimensions();
        SectPr.PgMar pgMar = page.getPgMar();
        SectPr sectPr = factory.createSectPr();
        body.setSectPr(sectPr);
        sectPr.setPgMar(pgMar);
        pgMar.setLeft(BigInteger.valueOf(1022L));
        pgMar.setRight(BigInteger.valueOf(1022L));
        pgMar.setTop(BigInteger.valueOf(2266L));
        pgMar.setBottom(BigInteger.valueOf(1133L));
        if (this.pageSize != null) {
            SectPr.PgSz pgSz = factory.createSectPrPgSz();
            pgSz.setW(BigInteger.valueOf(this.pageSize.getWidth()));
            pgSz.setH(BigInteger.valueOf(this.pageSize.getHeight()));
            sectPr.setPgSz(pgSz);
        }
    }
}

