/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.style;

import java.math.BigInteger;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.dita.style.StyleEngine;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTTblPPr;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STLineSpacingRule;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Text;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;

public class WordStyleUtil {
    public static ObjectFactory getFactory() {
        return Context.getWmlObjectFactory();
    }

    public static void setTextSize(int textSize, R run) {
        RPr runProperties = WordStyleUtil.getProperties(run);
        HpsMeasure size = new HpsMeasure();
        size.setVal(new BigInteger("" + textSize * 2));
        runProperties.setSz(size);
    }

    public static void setAlignment(StyleEngine.Alignment alignment, P paragraph) {
        PPr paragraphProperties = WordStyleUtil.getProperties(paragraph);
        Jc justification = WordStyleUtil.getFactory().createJc();
        if (alignment == StyleEngine.Alignment.JUSTIFY) {
            justification.setVal(JcEnumeration.BOTH);
        } else if (alignment == StyleEngine.Alignment.RIGHT) {
            justification.setVal(JcEnumeration.RIGHT);
        } else if (alignment == StyleEngine.Alignment.CENTER) {
            justification.setVal(JcEnumeration.CENTER);
        } else {
            justification.setVal(JcEnumeration.LEFT);
        }
        paragraphProperties.setJc(justification);
    }

    public static void setBold(boolean isBold, R run) {
        RPr runProperties = WordStyleUtil.getProperties(run);
        BooleanDefaultTrue bdt = WordStyleUtil.getFactory().createBooleanDefaultTrue();
        if (isBold) {
            runProperties.setB(bdt);
        }
    }

    public static void setItalic(boolean isItalic, R run) {
        RPr runProperties = WordStyleUtil.getProperties(run);
        BooleanDefaultTrue bdt = WordStyleUtil.getFactory().createBooleanDefaultTrue();
        if (isItalic) {
            runProperties.setI(bdt);
        }
    }

    public static void setUnderline(boolean isUnderline, R run) {
        RPr runProperties = WordStyleUtil.getProperties(run);
        if (isUnderline) {
            U underline = new U();
            underline.setVal(UnderlineEnumeration.SINGLE);
            runProperties.setU(underline);
        }
    }

    public static void setLineSpacing(int before, int after, int line, P paragraph) {
        PPr pProperties = WordStyleUtil.getProperties(paragraph);
        PPrBase.Spacing spacing = WordStyleUtil.getFactory().createPPrBaseSpacing();
        if (before >= 0) {
            spacing.setBefore(BigInteger.valueOf(before * 20));
        }
        if (after >= 0) {
            spacing.setAfter(BigInteger.valueOf(after * 20));
        }
        if (line > 0) {
            spacing.setLine(BigInteger.valueOf(line * 20));
            spacing.setLineRule(STLineSpacingRule.EXACT);
        }
        pProperties.setSpacing(spacing);
    }

    public static void setLineSpacing(int before, int after, Tbl table) {
        TblPr tblProperties = WordStyleUtil.getProperties(table);
        CTTblPPr tblpProperties = WordStyleUtil.getProperties(tblProperties);
        if (before >= 0) {
            tblpProperties.setTopFromText(BigInteger.valueOf(before * 20));
        }
        if (after >= 0) {
            tblpProperties.setBottomFromText(BigInteger.valueOf(after * 20));
        }
    }

    public static void setIndention(int left, int right, P paragraph) {
        PPr pProperties = WordStyleUtil.getProperties(paragraph);
        PPrBase.Ind ind = new PPrBase.Ind();
        if (left >= 0) {
            ind.setLeft(BigInteger.valueOf(left * 20));
        }
        if (right >= 0) {
            ind.setRight(BigInteger.valueOf(right * 20));
        }
        pProperties.setInd(ind);
    }

    public static void setColor(String color, R run) {
        RPr runProperties = WordStyleUtil.getProperties(run);
        Color c = new Color();
        c.setVal(color);
        runProperties.setColor(c);
    }

    public static PPr getProperties(P paragraph) {
        PPr pProperties = paragraph.getPPr();
        if (pProperties == null) {
            pProperties = WordStyleUtil.getFactory().createPPr();
            paragraph.setPPr(pProperties);
        }
        return pProperties;
    }

    public static RPr getProperties(R run) {
        RPr runProperties = run.getRPr();
        if (runProperties == null) {
            runProperties = WordStyleUtil.getFactory().createRPr();
            run.setRPr(runProperties);
        }
        return runProperties;
    }

    public static TblPr getProperties(Tbl table) {
        TblPr tblProperties = table.getTblPr();
        if (tblProperties == null) {
            tblProperties = WordStyleUtil.getFactory().createTblPr();
            table.setTblPr(tblProperties);
        }
        return tblProperties;
    }

    public static CTTblPPr getProperties(TblPr tblPr) {
        CTTblPPr tblpProperties = tblPr.getTblpPr();
        if (tblpProperties == null) {
            tblpProperties = WordStyleUtil.getFactory().createCTTblPPr();
            tblPr.setTblpPr(tblpProperties);
        }
        return tblpProperties;
    }

    public static void createNumbering(P paragraph, int level, int numId) {
        WordStyleUtil.createNumbering(paragraph, level, numId, "ListParagraph");
    }

    public static void createNumbering(P paragraph, int level, int numId, String pStyleName) {
        PPr ppr = WordStyleUtil.getProperties(paragraph);
        PPrBase.NumPr numPr = WordStyleUtil.getFactory().createPPrBaseNumPr();
        ppr.setNumPr(numPr);
        PPrBase.NumPr.Ilvl ilvlElement = WordStyleUtil.getFactory().createPPrBaseNumPrIlvl();
        numPr.setIlvl(ilvlElement);
        ilvlElement.setVal(BigInteger.valueOf(level));
        PPrBase.NumPr.NumId numIdElement = WordStyleUtil.getFactory().createPPrBaseNumPrNumId();
        numPr.setNumId(numIdElement);
        numIdElement.setVal(BigInteger.valueOf(numId));
        PPrBase.PStyle pStyle = new PPrBase.PStyle();
        pStyle.setVal(pStyleName);
        ppr.setPStyle(pStyle);
    }

    private static P createNumberedParagraph(long numId, long ilvl, String paragraphText) {
        P p = WordStyleUtil.getFactory().createP();
        Text t = WordStyleUtil.getFactory().createText();
        t.setValue(paragraphText);
        R run = WordStyleUtil.getFactory().createR();
        run.getRunContent().add(t);
        p.getParagraphContent().add(run);
        PPr ppr = WordStyleUtil.getFactory().createPPr();
        p.setPPr(ppr);
        PPrBase.NumPr numPr = WordStyleUtil.getFactory().createPPrBaseNumPr();
        ppr.setNumPr(numPr);
        PPrBase.NumPr.Ilvl ilvlElement = WordStyleUtil.getFactory().createPPrBaseNumPrIlvl();
        numPr.setIlvl(ilvlElement);
        ilvlElement.setVal(BigInteger.valueOf(ilvl));
        PPrBase.NumPr.NumId numIdElement = WordStyleUtil.getFactory().createPPrBaseNumPrNumId();
        numPr.setNumId(numIdElement);
        numIdElement.setVal(BigInteger.valueOf(numId));
        return p;
    }

    public static void outputStyles(WordprocessingMLPackage wordMLPackage) {
        try {
            for (Style style : ((Styles)wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart().getContents()).getStyle()) {
                System.out.println("Style " + style.getStyleId() + " : " + style.getName().getVal());
            }
        }
        catch (Docx4JException e) {
            throw new IbeeException((Throwable)e);
        }
    }
}

