/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.file.FileUtil;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.CTSettings;

public class TemplateUtil {
    public static WordprocessingMLPackage getTemplate(String source, String target) throws Docx4JException, FileNotFoundException, IOException {
        WordprocessingMLPackage wordMLPackage;
        String WORDPROCESSINGML_DOCUMENT = "application/vnd.openxmlformats-   officedocument.wordprocessingml.document.main+xml";
        new ContentType(WORDPROCESSINGML_DOCUMENT);
        String templatePath = source;
        File sourceFile = new File(source);
        File targetFile = new File(target);
        TemplateUtil.copyFileUsingFileChannels(sourceFile, targetFile);
        Throwable throwable = null;
        Object var8_8 = null;
        try (InputStream in = FileUtil.openInputStream((File)targetFile);){
            wordMLPackage = WordprocessingMLPackage.load((InputStream)in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ContentTypeManager ctm = wordMLPackage.getContentTypeManager();
        try {
            ctm.addOverrideContentType(new URI("/word/document.xml"), WORDPROCESSINGML_DOCUMENT);
        }
        catch (URISyntaxException e) {
            throw new IbeeException((Throwable)e);
        }
        DocumentSettingsPart dsp = new DocumentSettingsPart();
        CTSettings settings = Context.getWmlObjectFactory().createCTSettings();
        dsp.setJaxbElement((Object)settings);
        wordMLPackage.getMainDocumentPart().addTargetPart((Part)dsp);
        RelationshipsPart rp = RelationshipsPart.createRelationshipsPartForPart((Base)dsp);
        Relationship rel = new ObjectFactory().createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/attachedTemplate");
        rel.setTarget(templatePath);
        rel.setTargetMode("External");
        rp.addRelationship(rel);
        try {
            settings.setAttachedTemplate((CTRel)XmlUtils.unmarshalString((String)("<w:attachedTemplate xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"  xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" r:id=\"" + rel.getId() + "\"/>"), (JAXBContext)Context.jc, CTRel.class));
        }
        catch (JAXBException e) {
            throw new IbeeException((Throwable)e);
        }
        return wordMLPackage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyFileUsingFileChannels(File source, File dest) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(source);
            try {
                block24: {
                    FileOutputStream fos = new FileOutputStream(dest);
                    try {
                        block23: {
                            FileChannel inputChannel = fis.getChannel();
                            try {
                                try (FileChannel outputChannel = fos.getChannel();){
                                    outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
                                }
                                if (inputChannel == null) break block23;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (inputChannel == null) throw throwable;
                                inputChannel.close();
                                throw throwable;
                            }
                            inputChannel.close();
                        }
                        if (fos == null) break block24;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                if (fis == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }
}

