/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template.html;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.dita.builder.dom.DomDocumentBuilder;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.template.ATemplateProcessor;
import net.edgemind.ibee.dita.template.html.DefaultHtmlTemplateCreator;
import net.edgemind.ibee.dita.writer.html.HtmlDomSerializer;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;

public class HtmlTemplateProcessor
extends ATemplateProcessor {
    private DomDocumentBuilder documentBuilder;
    private List<String> cssFiles = null;
    private List<String> jsFiles = null;

    public void setCssFiles(List<String> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public void setJsFiles(List<String> jsFiles) {
        this.jsFiles = jsFiles;
    }

    @Override
    public void processDefaultTemplate(DitaElement defaultTemplateItem, File outputFile) throws DitaException {
        this.templateItems.put("all", defaultTemplateItem);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader reader = this.getDefaultTemplateReader();){
                this.processTemplate(reader, outputFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }

    @Override
    public void processTemplate(File templateFile, File outputFile) throws DitaException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader reader = this.getTemplateReader(templateFile);){
                this.processTemplate(reader, outputFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }

    public void processTemplate(Reader templateReader, File outputFile) throws DitaException {
        try {
            BufferedReader bufTemplateReader = new BufferedReader(templateReader);
            FileUtil.createDir((File)outputFile.getParentFile());
            FileWriter writer = new FileWriter(outputFile, this.getCharset());
            BufferedWriter bufWriter = new BufferedWriter(writer);
            this.documentBuilder = this.createDocumentBuilder();
            ArrayList<String> lines = new ArrayList<String>();
            String content = bufTemplateReader.readLine();
            while (content != null) {
                lines.add(content);
                content = bufTemplateReader.readLine();
            }
            bufTemplateReader.close();
            for (String line : lines) {
                Matcher matcher = this.templateKeyFinder.getMatcher(line);
                this.replaceTemplateItem(line, matcher, bufWriter);
                bufWriter.append(System.lineSeparator());
            }
            bufWriter.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new DitaException(e);
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }

    private DomDocumentBuilder createDocumentBuilder() {
        DomDocumentBuilder builder = new DomDocumentBuilder();
        builder.setCssFiles(this.cssFiles);
        builder.setJsFiles(this.jsFiles);
        builder.writeSingleDocument(true);
        return builder;
    }

    private void replaceTemplateItem(String line, Matcher matcher, Writer writer) throws DitaException {
        try {
            int lastIndex = 0;
            while (matcher.find()) {
                writer.append(line, lastIndex, matcher.start());
                String key = matcher.group("placeholder");
                Document doc = XmlUtil.createNewDocument();
                this.documentBuilder.setDocument(doc);
                DitaElement item = (DitaElement)this.templateItems.get(key);
                if (item == null) {
                    throw new IbeeException(String.format("Template item '%s' is not provided", key));
                }
                this.documentBuilder.create(item);
                this.write(doc, writer);
                lastIndex = matcher.end();
            }
            if (lastIndex < line.length()) {
                writer.append(line, lastIndex, line.length());
            }
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }

    private void write(Document doc, Writer writer) throws IOException {
        HtmlDomSerializer htmlSerializer = new HtmlDomSerializer();
        htmlSerializer.write(doc, writer);
    }

    private Reader getTemplateReader(File templateFile) throws IOException {
        if (templateFile == null) {
            throw new IOException("No template specified");
        }
        if (!templateFile.exists()) {
            throw new IOException(String.format("Template '%s' not found", templateFile.getAbsolutePath()));
        }
        return FileUtil.openReader((File)templateFile, (Charset)this.getCharset());
    }

    private Reader getDefaultTemplateReader() throws IOException {
        DefaultHtmlTemplateCreator creator = new DefaultHtmlTemplateCreator();
        return creator.createDefaultTemplate();
    }
}

