/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template.word;

import net.edgemind.ibee.dita.style.PageSize;
import net.edgemind.ibee.dita.style.WordDefaultStyleCreator;
import net.edgemind.ibee.dita.writer.word.AbstractNumHelper;
import net.edgemind.ibee.dita.writer.word.NumberingUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Text;

public class DefaultWordTemplateCreator {
    private Integer fixTextSize;
    private PageSize pageSize;

    public void setTextSize(Integer fixTextSize) {
        this.fixTextSize = fixTextSize;
    }

    public WordprocessingMLPackage createDefaultTemplate() throws InvalidFormatException {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        NumberingUtil.initNumbering(wordMLPackage);
        Integer fixTitleSize = null;
        if (this.fixTextSize != null) {
            fixTitleSize = this.fixTextSize * 2;
        }
        AbstractNumHelper numHelper = new AbstractNumHelper();
        numHelper.setTitleSize(fixTitleSize);
        numHelper.createAbstractNum(wordMLPackage);
        this.createDefaultStyle(wordMLPackage);
        ObjectFactory factory = Context.getWmlObjectFactory();
        MainDocumentPart templateDocumentPart = wordMLPackage.getMainDocumentPart();
        Text t = factory.createText();
        t.setValue("${all}");
        R run = factory.createR();
        run.getContent().add(t);
        P p = factory.createP();
        templateDocumentPart.getContent().add(p);
        p.getContent().add(run);
        return wordMLPackage;
    }

    private void createDefaultStyle(WordprocessingMLPackage wordMLPackage) {
        WordDefaultStyleCreator styleCreator = new WordDefaultStyleCreator();
        styleCreator.setPageSize(this.pageSize);
        styleCreator.createDefaultStyle(wordMLPackage);
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }
}

