/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.template.word;

import jakarta.xml.bind.JAXBElement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.dita.builder.word.WordDocumentBuilder;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaTextElement;
import net.edgemind.ibee.dita.style.PageSize;
import net.edgemind.ibee.dita.template.ATemplateProcessor;
import net.edgemind.ibee.dita.template.word.DefaultWordTemplateCreator;
import net.edgemind.ibee.dita.writer.word.AddingPageNrToFooter;
import net.edgemind.ibee.util.file.FileUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Text;

public class WordTemplateProcessor
extends ATemplateProcessor {
    private WordprocessingMLPackage wordMLPackage;
    private ObjectFactory factory;
    private Integer fixTextSize;
    private PageSize pageSize = PageSize.A4_PORTRAIT;
    private boolean showPageNumbers;
    private WordDocumentBuilder documentBuilder;

    public void setShowPageNumbers(boolean value) {
        this.showPageNumbers = value;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = pageSize;
    }

    public void setTextSize(Integer fixTextSize) {
        this.fixTextSize = fixTextSize;
    }

    @Override
    public void processDefaultTemplate(DitaElement defaultTemplateItem, File outputFile) throws DitaException {
        this.templateItems.put("all", defaultTemplateItem);
        try {
            WordprocessingMLPackage wordMLPackage = this.getDefaultTemplateWordMLPackage();
            this.processTemplate(wordMLPackage, outputFile);
        }
        catch (IOException | Docx4JException e) {
            throw new DitaException((Exception)e);
        }
    }

    @Override
    public void processTemplate(File templateFile, File outputFile) throws DitaException {
        try {
            WordprocessingMLPackage wordMLPackage = this.getTemplateWordMLPackage(templateFile);
            this.pageSize = this.getPageSizeFromDocument(wordMLPackage, PageSize.A4_PORTRAIT);
            this.processTemplate(wordMLPackage, outputFile);
        }
        catch (IOException | Docx4JException e) {
            throw new DitaException((Exception)e);
        }
    }

    private PageSize getPageSizeFromDocument(WordprocessingMLPackage wordMLPackage, PageSize def) {
        PageSize pageSize = this.getPageSizeFromDocument(wordMLPackage);
        if (pageSize == null) {
            pageSize = def;
        }
        return pageSize;
    }

    private PageSize getPageSizeFromDocument(WordprocessingMLPackage wordMLPackage) {
        if (wordMLPackage.getDocumentModel().getSections().size() == 0) {
            return null;
        }
        SectPr sectPr = ((SectionWrapper)wordMLPackage.getDocumentModel().getSections().get(0)).getSectPr();
        if (sectPr == null) {
            return null;
        }
        SectPr.PgSz pgSz = sectPr.getPgSz();
        if (pgSz == null) {
            return null;
        }
        int wTwips = pgSz.getW().intValue();
        int hTwips = pgSz.getH().intValue();
        PageSize size = new PageSize(wTwips, hTwips);
        return size;
    }

    public void processTemplate(WordprocessingMLPackage templateWord, File outputFile) throws DitaException {
        try {
            this.wordMLPackage = templateWord;
            this.factory = Context.getWmlObjectFactory();
            this.documentBuilder = this.createDocumentBuilder(outputFile.getParentFile());
            this.processTemplate();
            if (this.showPageNumbers) {
                new AddingPageNrToFooter().addPageNumbers(this.wordMLPackage);
            }
            this.wordMLPackage.save(outputFile);
            this.log("File '" + outputFile.getAbsolutePath() + "' written successully", LogLevel.INFO);
        }
        catch (Exception e) {
            throw new DitaException(e);
        }
    }

    private WordDocumentBuilder createDocumentBuilder(File targetFolder) {
        WordDocumentBuilder builder = new WordDocumentBuilder();
        builder.setFactory(this.factory);
        builder.setStyleEngine(this.getStyleEngine());
        builder.setUseTemplating(true);
        builder.setPageSize(this.pageSize);
        builder.setWordMLPackage(this.wordMLPackage);
        builder.setTargetFolder(targetFolder);
        return builder;
    }

    public List<String> getAllTemplateKeys(File templateFile) throws IOException, Docx4JException {
        HashSet<String> allTemplateKeys = new HashSet<String>();
        WordprocessingMLPackage wordMLPackage = this.getTemplateWordMLPackage(templateFile);
        MainDocumentPart mainDocumentPart = wordMLPackage.getMainDocumentPart();
        ArrayList contentTemplates = new ArrayList(mainDocumentPart.getContent());
        for (Object contentTemplate : contentTemplates) {
            String line = this.getText(contentTemplate);
            allTemplateKeys.addAll(this.templateKeyFinder.getKeys(line));
        }
        return allTemplateKeys.stream().collect(Collectors.toList());
    }

    private void processTemplate() throws DitaException {
        MainDocumentPart mainDocumentPart = this.wordMLPackage.getMainDocumentPart();
        ArrayList contentTemplates = new ArrayList(mainDocumentPart.getContent());
        mainDocumentPart.getContent().removeAll(contentTemplates);
        for (Object contentTemplate : contentTemplates) {
            String line = this.getText(contentTemplate);
            List<String> keys = this.templateKeyFinder.getKeys(line);
            if (keys.size() > 0) {
                Matcher matcher = this.templateKeyFinder.getMatcher(line);
                this.replaceTemplateItem(line, matcher, this.wordMLPackage.getMainDocumentPart());
                this.addPageBreak(contentTemplate);
                continue;
            }
            this.wordMLPackage.getMainDocumentPart().getContent().add(contentTemplate);
        }
    }

    private void replaceTemplateItem(String line, Matcher matcher, MainDocumentPart document) throws DitaException {
        MainDocumentPart parent = document;
        boolean isTextItem = true;
        List<String> keys = this.templateKeyFinder.getKeys(line);
        for (String key : keys) {
            DitaElement reportItem = (DitaElement)this.templateItems.get(key);
            if (reportItem instanceof DitaTextElement || reportItem == null) continue;
            isTextItem = false;
        }
        if (!isTextItem) {
            if (matcher.find()) {
                String key;
                key = matcher.group("placeholder");
                this.documentBuilder.create((DitaElement)this.templateItems.get(key), document);
            }
        } else {
            int lastIndex = 0;
            while (matcher.find()) {
                String prefix = line.substring(lastIndex, matcher.start());
                parent = this.createText(prefix, (ContentAccessor)parent);
                String key = matcher.group("placeholder");
                if (this.templateItems.containsKey(key)) {
                    this.documentBuilder.create((DitaElement)this.templateItems.get(key), parent);
                } else {
                    parent = this.createText(String.format("{{Unresolved Key: %s}}", key), (ContentAccessor)parent);
                }
                lastIndex = matcher.end();
            }
            if (lastIndex < line.length()) {
                String value = line.substring(lastIndex, line.length());
                parent = this.createText(value, (ContentAccessor)parent);
            }
        }
    }

    private WordprocessingMLPackage getTemplateWordMLPackage(File templateFile) throws IOException, Docx4JException {
        if (templateFile == null) {
            throw new IOException("No template specified");
        }
        if (!templateFile.exists()) {
            throw new IOException(String.format("Template '%s' not found", templateFile.getAbsolutePath()));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream templateInputStream = FileUtil.openInputStream((File)templateFile);){
            return WordprocessingMLPackage.load((InputStream)templateInputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private WordprocessingMLPackage getDefaultTemplateWordMLPackage() throws IOException, Docx4JException {
        DefaultWordTemplateCreator creator = new DefaultWordTemplateCreator();
        creator.setTextSize(this.fixTextSize);
        creator.setPageSize(this.pageSize);
        return creator.createDefaultTemplate();
    }

    private P createText(String value, ContentAccessor parent) {
        Text t = this.factory.createText();
        t.setValue(value);
        R run = this.factory.createR();
        run.getContent().add(t);
        P p = null;
        if (parent instanceof P) {
            p = (P)parent;
            parent.getContent().add(run);
        } else {
            p = this.factory.createP();
            p.getContent().add(run);
            parent.getContent().add(p);
        }
        return p;
    }

    private String getText(Object object) {
        String value = "";
        if (object instanceof P) {
            P p = (P)object;
            for (Object content : p.getContent()) {
                value = String.format("%s%s", value, this.getText(content));
            }
        } else if (object instanceof R) {
            R run = (R)object;
            for (Object content : run.getContent()) {
                value = String.format("%s%s", value, this.getText(content));
            }
        } else if (object instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)object;
            value = String.format("%s%s", value, this.getText(element.getValue()));
        } else if (object instanceof Text) {
            Text text = (Text)object;
            value = String.format("%s%s", value, text.getValue());
        }
        return value;
    }

    private void addPageBreak(Object object) {
        this.keepPageBreak(object);
        this.wordMLPackage.getMainDocumentPart().getContent().add(object);
    }

    private void keepPageBreak(Object object) {
        if (object instanceof ContentAccessor) {
            ContentAccessor p = (ContentAccessor)object;
            ArrayList subObjectToRemove = new ArrayList();
            for (Object subObject : p.getContent()) {
                if (this.containsPageBreak(subObject)) continue;
                subObjectToRemove.add(subObject);
            }
            p.getContent().removeAll(subObjectToRemove);
        }
    }

    private boolean containsPageBreak(Object object) {
        if (this.isPageBreak(object)) {
            return true;
        }
        if (object instanceof ContentAccessor) {
            ContentAccessor p = (ContentAccessor)object;
            for (Object subObject : p.getContent()) {
                if (!this.containsPageBreak(subObject)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPageBreak(Object object) {
        return object instanceof CTBookmark || object instanceof CTMarkupRange;
    }
}

