/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.util;

import java.io.File;
import java.util.ArrayList;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaFactory;
import net.edgemind.ibee.dita.items.DitaLi;
import net.edgemind.ibee.dita.items.DitaP;
import net.edgemind.ibee.dita.items.DitaPre;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaString;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaUl;
import net.edgemind.ibee.dita.items.DitaXRef;

public class DitaUtil {
    public static boolean isAbsolute(String path) {
        File file = new File(path);
        return file.isAbsolute();
    }

    public static void appendString(String value, DitaElement parent) {
        DitaString span1 = DitaFactory.getInstance().createString();
        parent.append(span1);
        DitaUtil.copyDitaOutputClass(parent, span1);
        span1.setText(value);
    }

    public static void appendToc(String text, String linkId, DitaElement tocTag, int level) {
        DitaLi li = DitaFactory.getInstance().createLi();
        tocTag.append(li);
        li.addOutputClass("Level" + level);
        DitaXRef link = DitaFactory.getInstance().createXRef();
        li.append(link);
        link.setText(text);
        link.setHref(linkId);
    }

    public static void appendLi(DitaElement body, DitaElement ditaElement, int level) {
        DitaElement previousDita = body;
        int i = 1;
        while (i <= level) {
            DitaUl subUl = DitaFactory.getInstance().createUl();
            previousDita.append(subUl);
            previousDita = subUl;
            ++i;
        }
        DitaLi subLi = DitaFactory.getInstance().createLi();
        previousDita.append(subLi);
        subLi.addOutputClass("Level" + level);
        subLi.append(ditaElement);
    }

    public static DitaElement createAttrDocDitaElement(String attr, DitaSection body, int level) {
        if (level > 0) {
            DitaElement previousDita = body;
            int i = 1;
            while (i <= level) {
                DitaUl ul = DitaFactory.getInstance().createUl();
                previousDita.append(ul);
                previousDita = ul;
                ++i;
            }
            DitaLi li = DitaFactory.getInstance().createLi();
            previousDita.append(li);
            li.addOutputClass("Level" + level);
            DitaSection div = DitaFactory.getInstance().createSection();
            DitaElement ditaElement = DitaUtil.completeAttrDocSection(attr, div, level);
            li.append(div);
            return ditaElement;
        }
        DitaElement ditaElement = DitaUtil.createAttrDocParagraphe(attr, body, level);
        return ditaElement;
    }

    public static DitaElement completeAttrDocSection(String attr, DitaSection div, int level) {
        DitaP ditaP = DitaFactory.getInstance().createP();
        div.append(ditaP);
        DitaString span = DitaFactory.getInstance().createString();
        ditaP.append(span);
        span.addOutputClass("justify");
        span.addOutputClass("underline");
        span.setText(attr + ": ");
        return ditaP;
    }

    public static DitaElement createAttrDocParagraphe(String attr, DitaSection body, int level) {
        DitaP ditaP = DitaFactory.getInstance().createP();
        body.append(ditaP);
        DitaString span = DitaFactory.getInstance().createString();
        ditaP.append(span);
        span.addOutputClass("justify");
        span.addOutputClass("underline");
        span.setText(attr + ": ");
        return ditaP;
    }

    public static void copyDitaOutputClass(DitaElement source, DitaElement copy) {
        for (String outputClass : source.getOutputClasses()) {
            copy.addOutputClass(outputClass);
        }
    }

    public static void propagateStyle(DitaElement ditaElement, String style) {
        ditaElement.addOutputClass(style);
        for (DitaElement ditaChild : ditaElement.getChildren()) {
            DitaUtil.propagateStyle(ditaChild, style);
        }
    }

    public static DitaElement createCopyDita(DitaElement element) {
        DitaElement newDitaElement = null;
        if (element instanceof DitaP) {
            newDitaElement = DitaFactory.getInstance().createP();
        } else if (element instanceof DitaUl) {
            newDitaElement = DitaFactory.getInstance().createUl();
        } else if (element instanceof DitaLi) {
            newDitaElement = DitaFactory.getInstance().createLi();
        } else if (element instanceof DitaPre) {
            newDitaElement = DitaFactory.getInstance().createPre();
        } else if (element instanceof DitaString) {
            newDitaElement = DitaFactory.getInstance().createString();
        } else if (element instanceof DitaRow) {
            newDitaElement = DitaFactory.getInstance().createRow();
        } else if (element instanceof DitaEntry) {
            newDitaElement = DitaFactory.getInstance().createEntry();
        } else if (element instanceof DitaSection) {
            newDitaElement = DitaFactory.getInstance().createSection();
        }
        if (newDitaElement != null) {
            for (String outPutClass : element.getOutputClasses()) {
                newDitaElement.addOutputClass(outPutClass);
            }
        }
        return newDitaElement;
    }

    public static void removeEmptyRow(DitaTable table) {
        ArrayList<DitaRow> childrenToRemove = new ArrayList<DitaRow>();
        for (DitaElement ditaElement : table.getChildren()) {
            DitaRow row;
            if (!(ditaElement instanceof DitaRow) || (row = (DitaRow)ditaElement).getChildren() != null && row.getChildren().size() != 0) continue;
            childrenToRemove.add(row);
        }
        for (DitaElement ditaElement : childrenToRemove) {
            table.remove(ditaElement);
        }
    }
}

