/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.dita.items.DitaElement;
import net.edgemind.ibee.dita.items.DitaEntry;
import net.edgemind.ibee.dita.items.DitaFactory;
import net.edgemind.ibee.dita.items.DitaImage;
import net.edgemind.ibee.dita.items.DitaLi;
import net.edgemind.ibee.dita.items.DitaP;
import net.edgemind.ibee.dita.items.DitaPre;
import net.edgemind.ibee.dita.items.DitaRow;
import net.edgemind.ibee.dita.items.DitaSection;
import net.edgemind.ibee.dita.items.DitaString;
import net.edgemind.ibee.dita.items.DitaTable;
import net.edgemind.ibee.dita.items.DitaTitle;
import net.edgemind.ibee.dita.items.DitaUl;
import net.edgemind.ibee.dita.items.DitaXRef;
import net.edgemind.ibee.dita.util.DitaUtil;

public class HtmlToDitaConverter {
    public static void htmlToDita(String content, DitaElement currentDiv, DitaElement body, int level) {
        String rest = content;
        String[] mo = rest.split("<");
        if (mo.length == 1) {
            DitaString p = DitaFactory.getInstance().createString();
            if (!(body instanceof DitaLi)) {
                p.addOutputClass("Indent" + level);
            }
            DitaUtil.appendString(mo[0], p);
            currentDiv.append(p);
            return;
        }
        ArrayList<DitaElement> ditaStack = new ArrayList<DitaElement>();
        DitaSection firstDiv = DitaFactory.getInstance().createSection();
        ditaStack.add(firstDiv);
        String[] stringArray = mo;
        int n = mo.length;
        int n2 = 0;
        while (n2 < n) {
            String contentBeforeNextOpenTag = stringArray[n2];
            if (contentBeforeNextOpenTag.length() != 0) {
                DitaLi li;
                String bulletin;
                byte[] utf8Bytes = new byte[]{-17, -126, -73};
                try {
                    bulletin = new String(utf8Bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IbeeException((Throwable)e);
                }
                String[] subTags = contentBeforeNextOpenTag.split(bulletin);
                boolean close = false;
                String nextTag = subTags[0];
                if (!contentBeforeNextOpenTag.contains(">")) {
                    DitaElement element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                    DitaUtil.appendString(contentBeforeNextOpenTag, element);
                } else if (contentBeforeNextOpenTag.startsWith("/")) {
                    nextTag = contentBeforeNextOpenTag.substring(1);
                    close = true;
                }
                String[] tagWithContent = nextTag.split(">");
                String tagName = tagWithContent[0].trim();
                if (tagName.equalsIgnoreCase("p") || tagName.startsWith("p ")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        p = DitaFactory.getInstance().createP();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(p);
                        ditaStack.add(p);
                        if (!(element instanceof DitaLi)) {
                            p.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, p);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("span") || tagName.startsWith("span")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        span = DitaFactory.getInstance().createString();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(span);
                        ditaStack.add(span);
                        span.addOutputClass("justify");
                        if (!(element instanceof DitaLi)) {
                            span.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            if (tagName.contains("border-top")) {
                                tagText = "!";
                            }
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, span);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("ul") || tagName.startsWith("ul")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                    } else {
                        parent = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        DitaUl ul = DitaFactory.getInstance().createUl();
                        ditaStack.add(ul);
                        parent.append(ul);
                    }
                } else if (tagName.equalsIgnoreCase("li") || tagName.startsWith("li")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, --level);
                    } else {
                        parent = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        li = DitaFactory.getInstance().createLi();
                        ditaStack.add(li);
                        parent.append(li);
                        li.addOutputClass("Level" + ++level);
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, li);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("pre") || tagName.startsWith("pre")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        p = DitaFactory.getInstance().createP();
                        DitaPre pre = DitaFactory.getInstance().createPre();
                        p.append(pre);
                        DitaElement parent = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        parent.append(p);
                        ditaStack.add(p);
                        if (!(parent instanceof DitaLi)) {
                            p.addOutputClass("Indent" + level);
                            pre.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, pre);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("i") || tagName.startsWith("i ")) {
                    if (close) {
                        element = (DitaElement)ditaStack.remove(ditaStack.size() - 1);
                        DitaUtil.propagateStyle(element, "italic");
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        span = DitaFactory.getInstance().createString();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(span);
                        ditaStack.add(span);
                        span.addOutputClass("justify");
                        if (!(element instanceof DitaLi)) {
                            span.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, span);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("u") || tagName.startsWith("u ")) {
                    if (close) {
                        element = (DitaElement)ditaStack.remove(ditaStack.size() - 1);
                        DitaUtil.propagateStyle(element, "underline");
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        span = DitaFactory.getInstance().createString();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(span);
                        ditaStack.add(span);
                        span.addOutputClass("justify");
                        if (!(element instanceof DitaLi)) {
                            span.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, span);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("b") || tagName.startsWith("b ")) {
                    if (close) {
                        element = (DitaElement)ditaStack.remove(ditaStack.size() - 1);
                        DitaUtil.propagateStyle(element, "bold");
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        span = DitaFactory.getInstance().createString();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(span);
                        ditaStack.add(span);
                        span.addOutputClass("justify");
                        if (!(element instanceof DitaLi)) {
                            span.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, span);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("table") || tagName.startsWith("table")) {
                    if (close) {
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        if (element instanceof DitaTable) {
                            DitaUtil.removeEmptyRow((DitaTable)element);
                        }
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        DitaSection div = DitaFactory.getInstance().createSection();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(div);
                        DitaTable table = DitaFactory.getInstance().createTable();
                        div.append(table);
                        ditaStack.add(table);
                    }
                } else if (tagName.equalsIgnoreCase("tr") || tagName.startsWith("tr")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        DitaRow tr = DitaFactory.getInstance().createRow();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(tr);
                        ditaStack.add(tr);
                    }
                } else if (tagName.equalsIgnoreCase("th") || tagName.startsWith("th")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        DitaEntry th = DitaFactory.getInstance().createEntry();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(th);
                        ditaStack.add(th);
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, th);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("td") || tagName.startsWith("td")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        DitaEntry td = DitaFactory.getInstance().createEntry();
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(td);
                        ditaStack.add(td);
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, td);
                        }
                    }
                } else if (tagName.equalsIgnoreCase("br/") || tagName.startsWith("br") && tagName.endsWith("/")) {
                    DitaElement lastDitaElement = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                    if (!(lastDitaElement instanceof DitaLi)) {
                        lastDitaElement = (DitaElement)ditaStack.remove(ditaStack.size() - 1);
                        DitaElement previousDitaElement = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        DitaElement emptyCopyOfLastDitaElement = DitaUtil.createCopyDita(lastDitaElement);
                        previousDitaElement.append(emptyCopyOfLastDitaElement);
                        DitaP p = DitaFactory.getInstance().createP();
                        emptyCopyOfLastDitaElement.append(p);
                        ditaStack.add(emptyCopyOfLastDitaElement);
                        lastDitaElement = emptyCopyOfLastDitaElement;
                    }
                    if (tagWithContent.length > 1) {
                        Object tagText = "";
                        int i = 1;
                        while (i < tagWithContent.length) {
                            tagText = (String)tagText + tagWithContent[i];
                            ++i;
                        }
                        DitaUtil.appendString((String)tagText, lastDitaElement);
                    }
                } else if (tagName.startsWith("a")) {
                    if (close) {
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        String tagText = "<" + contentBeforeNextOpenTag + "</a>";
                        DitaXRef ref = HtmlToDitaConverter.createXRef(tagText);
                        DitaElement element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(ref);
                    }
                } else if (tagName.startsWith("h")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        p = DitaFactory.getInstance().createP();
                        DitaSection section = DitaFactory.getInstance().createSection();
                        DitaTitle title = DitaFactory.getInstance().createTitle();
                        Integer lastPosition = tagName.indexOf(" ");
                        Integer titleLevel = 1;
                        titleLevel = lastPosition != null && lastPosition > 1 ? Integer.valueOf(tagName.substring(1, lastPosition)) : Integer.valueOf(tagName.substring(1));
                        title.setLevel(titleLevel);
                        section.append(title);
                        p.append(section);
                        DitaElement element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        element.append(p);
                        ditaStack.add(p);
                        if (!(element instanceof DitaLi)) {
                            p.addOutputClass("Indent" + level);
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            title.setText((String)tagText);
                        }
                    }
                } else if (tagName.contains("img")) {
                    if (close) {
                        ditaStack.remove(ditaStack.size() - 1);
                        HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                    } else {
                        String splitTagSrc;
                        String[] splitSrcValues;
                        element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                        String[] splitTagValues = tagName.split("src=");
                        if (splitTagValues.length > 0 && (splitSrcValues = (splitTagSrc = splitTagValues[1]).split("\"")).length > 0) {
                            String imgPath = splitSrcValues[1];
                            if (imgPath.startsWith("file:/")) {
                                imgPath = imgPath.substring(6);
                            }
                            DitaImage img = DitaFactory.getInstance().createImage();
                            img.setHref(imgPath);
                            img.addOutputClass("display_block");
                            element.append(img);
                            if (!(element instanceof DitaLi)) {
                                img.addOutputClass("Indent" + level);
                            }
                        }
                        if (tagWithContent.length > 1) {
                            Object tagText = "";
                            int i = 1;
                            while (i < tagWithContent.length) {
                                tagText = (String)tagText + tagWithContent[i];
                                ++i;
                            }
                            DitaUtil.appendString((String)tagText, element);
                        }
                    }
                } else if (close) {
                    ditaStack.remove(ditaStack.size() - 1);
                    HtmlToDitaConverter.completePreviousDita(tagWithContent, ditaStack, level);
                } else {
                    span = DitaFactory.getInstance().createString();
                    element = (DitaElement)ditaStack.get(ditaStack.size() - 1);
                    element.append(span);
                    ditaStack.add(span);
                    span.addOutputClass("justify");
                    if (!(element instanceof DitaLi)) {
                        span.addOutputClass("Indent" + level);
                    }
                    if (tagWithContent.length > 1) {
                        Object tagText = "";
                        int i = 1;
                        while (i < tagWithContent.length) {
                            tagText = (String)tagText + tagWithContent[i];
                            ++i;
                        }
                        DitaUtil.appendString((String)tagText, span);
                    }
                }
                if (subTags.length > 1) {
                    int j = 1;
                    while (j < subTags.length) {
                        li = DitaFactory.getInstance().createLi();
                        ditaStack.add(li);
                        li.addOutputClass("Level" + (level + 1));
                        DitaUtil.appendString(subTags[j], li);
                        ++j;
                    }
                    DitaSection nextDiv = DitaFactory.getInstance().createSection();
                    ditaStack.add(nextDiv);
                }
            }
            ++n2;
        }
        for (DitaElement ditaElement : ditaStack) {
            if (ditaElement instanceof DitaLi) {
                DitaUl subUl = DitaFactory.getInstance().createUl();
                body.append(subUl);
                subUl.append(ditaElement);
                continue;
            }
            body.append(ditaElement);
        }
    }

    public static void completePreviousDita(String[] tagWithContent, List<DitaElement> ditaElements, int level) {
        if (ditaElements.size() == 0) {
            return;
        }
        DitaElement topElement = ditaElements.get(ditaElements.size() - 1);
        if (tagWithContent.length > 1) {
            Object tagText = "";
            int i = 1;
            while (i < tagWithContent.length) {
                tagText = (String)tagText + tagWithContent[i];
                ++i;
            }
            if (!((String)tagText).isEmpty()) {
                DitaUtil.appendString((String)tagText, topElement);
            }
        }
    }

    private static DitaXRef createXRef(String value) {
        DitaXRef ref = DitaFactory.getInstance().createXRef();
        String pattern = "<a\\s*href\\s*=\\s*\"(.*?)\"\\s*>(.*?)</a>";
        Pattern p = Pattern.compile(pattern, 2);
        Matcher matcher = p.matcher(value);
        if (matcher.find()) {
            String urlString = matcher.group(1);
            String name = matcher.group(2);
            ref.setHref(urlString);
            ref.setText(name);
        }
        return ref;
    }
}

