/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.dita.exception.DitaException;
import net.edgemind.ibee.util.file.FileUtil;

public class FileReplicator {
    public static void replicatePackagedFile(String sourcePath, Class clazz, String targetFolder) throws DitaException {
        String fileName = FileUtil.getFileName((String)sourcePath);
        String targetPath = targetFolder + File.separator + fileName;
        InputStream stream = clazz.getResourceAsStream(sourcePath);
        if (stream == null) {
            LogUtil.error((String)("copy " + sourcePath + " to " + targetFolder + " failed: resource not found"));
            throw new DitaException("Resource '" + sourcePath + "' not found");
        }
        try {
            FileUtil.createDir((String)targetFolder);
            FileUtil.copyFile((InputStream)stream, (File)new File(targetPath));
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }

    public static void replicateFileIntoDirectory(String sourcePath, String targetFolder) throws DitaException {
        try {
            String fileName = FileUtil.getFileName((String)sourcePath);
            String targetPath = targetFolder + File.separator + fileName;
            FileUtil.createDir((String)targetFolder);
            FileUtil.copyFile((File)new File(sourcePath), (File)new File(targetPath));
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }

    public static void replicateFile(String sourcePath, String targetPath) throws DitaException {
        try {
            String dir = FileUtil.getDir((String)targetPath);
            FileUtil.createDir((String)dir);
            FileUtil.copyFile((File)new File(sourcePath), (File)new File(targetPath));
        }
        catch (IOException e) {
            throw new DitaException(e);
        }
    }
}

